/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.processor.strategy.DirectSink;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import reactor.core.publisher.FluxSink;

public abstract class AbstractProcessingStrategy
implements ProcessingStrategy {
    public static final String TRANSACTIONAL_ERROR_MESSAGE = "Unable to process a transactional flow asynchronously";

    @Override
    public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
        return new DirectSink(pipeline, this.createOnEventConsumer());
    }

    protected Consumer<CoreEvent> createOnEventConsumer() {
        return event -> {
            if (TransactionCoordination.isTransactionActive()) {
                ((BaseEventContext)event.getContext()).error((Throwable)((Object)new MessagingException((CoreEvent)event, (Throwable)new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)TRANSACTIONAL_ERROR_MESSAGE)))));
            }
        };
    }

    protected ExecutorService decorateScheduler(Scheduler scheduler) {
        return scheduler;
    }

    static final class ReactorSink
    implements Sink,
    Disposable {
        private final FluxSink<CoreEvent> fluxSink;
        private final reactor.core.Disposable disposable;
        private final Consumer onEventConsumer;

        ReactorSink(FluxSink<CoreEvent> fluxSink, reactor.core.Disposable disposable, Consumer<CoreEvent> onEventConsumer) {
            this.fluxSink = fluxSink;
            this.disposable = disposable;
            this.onEventConsumer = onEventConsumer;
        }

        @Override
        public void accept(CoreEvent event) {
            this.onEventConsumer.accept(event);
            this.fluxSink.next((Object)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean emit(CoreEvent event) {
            this.onEventConsumer.accept(event);
            FluxSink<CoreEvent> fluxSink = this.fluxSink;
            synchronized (fluxSink) {
                if (this.fluxSink.requestedFromDownstream() > 0L) {
                    this.fluxSink.next((Object)event);
                    return true;
                }
                return false;
            }
        }

        public void dispose() {
            this.fluxSink.complete();
            this.disposable.dispose();
        }
    }
}

