/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.streaming.CursorContext;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;
import org.mule.runtime.core.internal.streaming.bytes.ManagedCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.object.ManagedCursorIteratorProvider;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CursorManager {
    private static Logger LOGGER = LoggerFactory.getLogger(CursorManager.class);
    private final LoadingCache<String, EventStreamingState> registry = CacheBuilder.newBuilder().removalListener(notification -> EventStreamingState.access$400((EventStreamingState)notification.getValue())).build((CacheLoader)new CacheLoader<String, EventStreamingState>(){

        public EventStreamingState load(String key) throws Exception {
            return new EventStreamingState();
        }
    });
    private MutableStreamingStatistics statistics;

    public CursorManager(MutableStreamingStatistics statistics) {
        this.statistics = statistics;
    }

    public CursorProvider manage(CursorProvider provider, CoreEvent creatorEvent) {
        BaseEventContext ownerContext = this.getRoot((BaseEventContext)creatorEvent.getContext());
        this.registerEventContext(ownerContext);
        ((EventStreamingState)this.registry.getUnchecked((Object)ownerContext.getId())).addProvider(provider);
        CursorContext context = new CursorContext(provider, ownerContext);
        if (provider instanceof CursorStreamProvider) {
            return new ManagedCursorStreamProvider(context, this);
        }
        if (provider instanceof CursorIteratorProvider) {
            return new ManagedCursorIteratorProvider(context, this);
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unknown cursor provider type: " + context.getClass().getName())));
    }

    public void onOpen(Cursor cursor, CursorContext providerHandle) {
        ((EventStreamingState)this.registry.getUnchecked((Object)providerHandle.getOwnerContext().getId())).addCursor(providerHandle.getCursorProvider(), cursor);
        this.statistics.incrementOpenCursors();
    }

    public void onClose(Cursor cursor, CursorContext handle) {
        String eventId = handle.getOwnerContext().getId();
        EventStreamingState state = (EventStreamingState)this.registry.getIfPresent((Object)eventId);
        if (state != null && state.removeCursor(handle.getCursorProvider(), cursor)) {
            state.dispose();
            this.registry.invalidate((Object)eventId);
        }
    }

    private void terminated(BaseEventContext rootContext) {
        EventStreamingState state = (EventStreamingState)this.registry.getIfPresent((Object)rootContext.getId());
        if (state != null) {
            state.dispose();
            this.registry.invalidate((Object)rootContext.getId());
        }
    }

    private void registerEventContext(BaseEventContext eventContext) {
        Mono.from(eventContext.getCompletionPublisher()).subscribe(null, null, () -> this.terminated(eventContext));
    }

    private BaseEventContext getRoot(BaseEventContext eventContext) {
        return eventContext.getParentContext().map(this::getRoot).orElse(eventContext);
    }

    private class EventStreamingState {
        private boolean disposed = false;
        private final LoadingCache<CursorProvider, List<Cursor>> cursors = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CursorProvider, List<Cursor>>(){

            public List<Cursor> load(CursorProvider key) throws Exception {
                CursorManager.this.statistics.incrementOpenProviders();
                return new LinkedList<Cursor>();
            }
        });

        private EventStreamingState() {
        }

        private synchronized void addProvider(CursorProvider adapter) {
            this.cursors.getUnchecked((Object)adapter);
        }

        private void addCursor(CursorProvider provider, Cursor cursor) {
            ((List)this.cursors.getUnchecked((Object)provider)).add(cursor);
        }

        private boolean removeCursor(CursorProvider provider, Cursor cursor) {
            List openCursors = (List)this.cursors.getUnchecked((Object)provider);
            if (openCursors.remove(cursor)) {
                CursorManager.this.statistics.decrementOpenCursors();
            }
            if (openCursors.isEmpty() && provider.isClosed()) {
                this.dispose();
                this.cursors.invalidate((Object)provider);
                return true;
            }
            return false;
        }

        private void dispose() {
            if (this.disposed) {
                return;
            }
            this.cursors.asMap().forEach((provider, cursors) -> {
                try {
                    this.closeProvider((CursorProvider)provider);
                    this.releaseAll((List<Cursor>)cursors);
                }
                finally {
                    provider.releaseResources();
                }
            });
            this.disposed = true;
        }

        private void releaseAll(List<Cursor> cursors) {
            cursors.forEach(cursor -> {
                try {
                    cursor.release();
                    CursorManager.this.statistics.decrementOpenCursors();
                }
                catch (Exception e) {
                    LOGGER.warn("Exception was found trying to close cursor. Execution will continue", (Throwable)e);
                }
            });
        }

        private void closeProvider(CursorProvider provider) {
            if (!provider.isClosed()) {
                provider.close();
                CursorManager.this.statistics.decrementOpenProviders();
            }
        }
    }
}

