/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalType;
import reactor.util.annotation.Nullable;

final class FluxDoOnEach<T>
extends FluxOperator<T, T> {
    final Consumer<? super Signal<T>> onSignal;

    FluxDoOnEach(Flux<? extends T> source, Consumer<? super Signal<T>> onSignal) {
        super(source);
        this.onSignal = Objects.requireNonNull(onSignal, "onSignal");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new DoOnEachSubscriber<T>(actual, this.onSignal));
    }

    static final class DoOnEachSubscriber<T>
    implements InnerOperator<T, T>,
    Signal<T> {
        final CoreSubscriber<? super T> actual;
        final Consumer<? super Signal<T>> onSignal;
        T t;
        Subscription s;
        boolean done;

        DoOnEachSubscriber(CoreSubscriber<? super T> actual, Consumer<? super Signal<T>> onSignal) {
            this.actual = actual;
            this.onSignal = onSignal;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.s = s;
            this.actual.onSubscribe(s);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            try {
                this.t = t;
                this.onSignal.accept(this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return;
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            block5: {
                if (this.done) {
                    Operators.onErrorDropped(t, this.actual.currentContext());
                    return;
                }
                this.done = true;
                try {
                    this.onSignal.accept(Signal.error(t));
                }
                catch (Throwable e) {
                    t = Operators.onOperatorError(null, e, t, this.actual.currentContext());
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t) break block5;
                    throw use;
                }
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            try {
                this.onSignal.accept(Signal.complete());
            }
            catch (Throwable e) {
                this.done = false;
                this.onError(Operators.onOperatorError(this.s, e, this.actual.currentContext()));
                return;
            }
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public Throwable getThrowable() {
            return null;
        }

        @Override
        @Nullable
        public Subscription getSubscription() {
            return null;
        }

        @Override
        @Nullable
        public T get() {
            return this.t;
        }

        @Override
        public SignalType getType() {
            return SignalType.ON_NEXT;
        }
    }
}

