/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;
import reactor.core.scheduler.Scheduler;
import reactor.util.annotation.Nullable;

final class FluxWindowTimeOrSize<T>
extends FluxOperator<T, Flux<T>> {
    final int batchSize;
    final long timespan;
    final Scheduler timer;

    FluxWindowTimeOrSize(Flux<T> source, int maxSize, long timespan, Scheduler timer) {
        super(source);
        if (timespan <= 0L) {
            throw new IllegalArgumentException("Timeout period must be strictly positive");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be strictly positive");
        }
        this.timer = Objects.requireNonNull(timer, "Timer");
        this.timespan = timespan;
        this.batchSize = maxSize;
    }

    @Override
    public void subscribe(CoreSubscriber<? super Flux<T>> actual) {
        this.source.subscribe(new WindowTimeoutSubscriber(Operators.serialize(actual), this.batchSize, this.timespan, this.timer));
    }

    static final class WindowTimeoutSubscriber<T>
    implements InnerOperator<T, Flux<T>> {
        static final int NOT_TERMINATED = 0;
        static final int TERMINATED_WITH_SUCCESS = 1;
        static final int TERMINATED_WITH_ERROR = 2;
        static final int TERMINATED_WITH_CANCEL = 3;
        final CoreSubscriber<? super Flux<T>> actual;
        final int batchSize;
        final Runnable flushTask;
        final Scheduler.Worker timer;
        final Scheduler timerScheduler;
        final long timespan;
        Window<T> currentWindow;
        Subscription subscription;
        volatile Disposable timespanRegistration;
        volatile int cancelled;
        volatile int index;
        volatile int initialWindowEmitted;
        volatile long requested;
        volatile int terminated = 0;
        volatile int windowCount;
        static final AtomicIntegerFieldUpdater<WindowTimeoutSubscriber> CANCELLED = AtomicIntegerFieldUpdater.newUpdater(WindowTimeoutSubscriber.class, "cancelled");
        static final AtomicIntegerFieldUpdater<WindowTimeoutSubscriber> INDEX = AtomicIntegerFieldUpdater.newUpdater(WindowTimeoutSubscriber.class, "index");
        static final AtomicIntegerFieldUpdater<WindowTimeoutSubscriber> INITIAL_WINDOW_EMITTED = AtomicIntegerFieldUpdater.newUpdater(WindowTimeoutSubscriber.class, "initialWindowEmitted");
        static final AtomicLongFieldUpdater<WindowTimeoutSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowTimeoutSubscriber.class, "requested");
        static final AtomicIntegerFieldUpdater<WindowTimeoutSubscriber> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(WindowTimeoutSubscriber.class, "terminated");
        static final AtomicIntegerFieldUpdater<WindowTimeoutSubscriber> WINDOW_COUNT = AtomicIntegerFieldUpdater.newUpdater(WindowTimeoutSubscriber.class, "windowCount");

        WindowTimeoutSubscriber(CoreSubscriber<? super Flux<T>> actual, int maxSize, long timespan, Scheduler timer) {
            this.actual = actual;
            this.timespan = timespan;
            this.timerScheduler = timer;
            this.timer = timer.createWorker();
            this.flushTask = () -> {
                if (this.terminated == 0) {
                    int index;
                    while (!INDEX.compareAndSet(this, index = this.index, 0)) {
                    }
                    this.windowCloseByTimeout();
                }
            };
            this.batchSize = maxSize;
            WINDOW_COUNT.lazySet(this, 1);
        }

        void subscribeAndCreateWindow() {
            try {
                this.timespanRegistration = this.timer.schedule(this.flushTask, this.timespan, TimeUnit.MILLISECONDS);
                WINDOW_COUNT.getAndIncrement(this);
                this.currentWindow = new Window(this.timerScheduler);
                this.actual.onSubscribe(this);
            }
            catch (RejectedExecutionException ree) {
                RuntimeException error = Operators.onRejectedExecution(ree, this.subscription, null, null, this.actual.currentContext());
                Operators.error(this.actual, error);
            }
        }

        void windowCreateAndEmit() {
            if (this.timerStart()) {
                WINDOW_COUNT.getAndIncrement(this);
                Window _currentWindow = new Window(this.timerScheduler);
                this.currentWindow = _currentWindow;
                this.actual.onNext(_currentWindow);
            }
        }

        void windowCloseByTimeout() {
            if (this.currentWindow != null) {
                if (INITIAL_WINDOW_EMITTED.compareAndSet(this, 0, 1)) {
                    this.actual.onNext(this.currentWindow);
                }
                this.currentWindow.onComplete();
                this.currentWindow = null;
                this.dispose();
            }
            this.windowCreateAndEmit();
        }

        void windowCloseBySize() {
            if (this.currentWindow != null) {
                this.currentWindow.onComplete();
                this.currentWindow = null;
                this.dispose();
            }
            this.windowCreateAndEmit();
        }

        boolean timerStart() {
            try {
                this.timespanRegistration = this.timer.schedule(this.flushTask, this.timespan, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (RejectedExecutionException ree) {
                this.onError(Operators.onRejectedExecution(ree, this.actual.currentContext()));
                return false;
            }
        }

        void timerCancel() {
            if (this.timespanRegistration != null) {
                this.timespanRegistration.dispose();
                this.timespanRegistration = null;
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                this.subscribeAndCreateWindow();
            }
        }

        public void onNext(T value) {
            int index;
            if (this.currentWindow != null && INITIAL_WINDOW_EMITTED.compareAndSet(this, 0, 1)) {
                this.actual.onNext(this.currentWindow);
            }
            while (!INDEX.compareAndSet(this, (index = this.index + 1) - 1, index)) {
            }
            if (this.currentWindow != null) {
                this.currentWindow.onNext(value);
            }
            if (index % this.batchSize == 0) {
                this.index = 0;
                this.timerCancel();
                this.windowCloseBySize();
            }
        }

        public void onComplete() {
            if (TERMINATED.compareAndSet(this, 0, 1)) {
                this.timerCancel();
                this.timer.dispose();
                if (this.currentWindow != null) {
                    this.currentWindow.onComplete();
                    this.currentWindow = null;
                    this.dispose();
                }
                this.actual.onComplete();
            }
        }

        public void onError(Throwable throwable) {
            if (TERMINATED.compareAndSet(this, 0, 2)) {
                this.timerCancel();
                this.timer.dispose();
                if (this.currentWindow != null) {
                    this.currentWindow.onError(throwable);
                    this.currentWindow = null;
                    this.dispose();
                }
                this.actual.onError(throwable);
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled == 1;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.subscription;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.terminated == 2 || this.terminated == 1;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CAPACITY) {
                return this.batchSize;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.batchSize - this.index;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        final boolean isCompleted() {
            return this.terminated == 1;
        }

        final boolean isFailed() {
            return this.terminated == 2;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.terminated != 0) {
                    return;
                }
                if (this.batchSize == Integer.MAX_VALUE || n == Long.MAX_VALUE) {
                    this.requestMore(Long.MAX_VALUE);
                } else {
                    this.requestMore(Operators.multiplyCap(n, this.batchSize));
                }
            }
        }

        final void requestMore(long n) {
            Subscription s = this.subscription;
            if (s != null) {
                s.request(n);
            }
        }

        @Override
        public CoreSubscriber<? super Flux<T>> actual() {
            return this.actual;
        }

        public void cancel() {
            if (CANCELLED.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        void doCancel() {
            if (TERMINATED.compareAndSet(this, 0, 3)) {
                this.timer.dispose();
                Subscription s = this.subscription;
                if (s != null) {
                    this.subscription = null;
                    s.cancel();
                }
            }
        }

        public void dispose() {
            if (WINDOW_COUNT.decrementAndGet(this) == 0 && this.cancelled == 1) {
                this.doCancel();
            }
        }

        public String toString() {
            return super.toString() + "{" + (this.timer != null ? "timed - " + this.timespan + " ms" : "") + " batchSize=" + this.index + "/" + this.batchSize + " [" + (int)((float)this.index / (float)this.batchSize * 100.0f) + "%]";
        }
    }

    static final class Window<T>
    extends Flux<T>
    implements InnerOperator<T, T> {
        final UnicastProcessor<T> processor = UnicastProcessor.create();
        final Scheduler timer;
        int count = 0;

        Window(Scheduler timer) {
            this.timer = timer;
        }

        @Override
        public void onSubscribe(Subscription s) {
        }

        public void onNext(T t) {
            ++this.count;
            this.processor.onNext(t);
        }

        public void onError(Throwable t) {
            this.processor.onError(t);
        }

        public void onComplete() {
            this.processor.onComplete();
        }

        @Override
        public void subscribe(CoreSubscriber<? super T> actual) {
            this.processor.subscribe(actual);
        }

        public void request(long n) {
        }

        public void cancel() {
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.processor;
        }
    }
}

