/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.config.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.api.dsl.model.ComponentModel;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ComponentLocationVisitor
implements Consumer<ComponentModel> {
    public static final ComponentIdentifier BATCH_JOB_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:job");
    public static final ComponentIdentifier BATCH_PROCESSS_RECORDS_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:process-records");
    private static final ComponentIdentifier BATCH_ON_COMPLETE_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:on-complete");
    private static final ComponentIdentifier BATCH_STEP_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:step");
    private static final ComponentIdentifier BATCH_AGGREGATOR_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:aggregator");
    private static final String PROCESSORS_PART_NAME = "processors";
    private static final ComponentIdentifier ROUTE_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"mule:route");
    private static final ComponentIdentifier CHOICE_WHEN_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"mule:when");
    private static final ComponentIdentifier CHOICE_OTHERWISE_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"mule:otherwise");

    @Override
    public void accept(ComponentModel componentModel) {
        DefaultComponentLocation componentLocation;
        if (componentModel.getParent() == null) {
            return;
        }
        Optional<TypedComponentIdentifier> typedComponentIdentifier = Optional.of(TypedComponentIdentifier.builder().identifier(componentModel.getIdentifier()).type(ComponentModelHelper.resolveComponentType(componentModel)).build());
        if (componentModel.isRoot()) {
            String componentModelNameAttribute = componentModel.getNameAttribute();
            ImmutableList parts = ImmutableList.builder().add((Object)new DefaultComponentLocation.DefaultLocationPart(componentModelNameAttribute, typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber())).build();
            componentLocation = new DefaultComponentLocation(Optional.ofNullable(componentModelNameAttribute), (List)parts);
        } else if (this.existsWithinRootContainer(componentModel) || this.existsWithinSubflow(componentModel)) {
            ComponentModel parentComponentModel = componentModel.getParent();
            DefaultComponentLocation parentComponentLocation = parentComponentModel.getComponentLocation();
            if (this.isHttpProxyPart(componentModel)) {
                componentLocation = parentComponentLocation.appendLocationPart(componentModel.getIdentifier().getName(), typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
            } else if (this.isRootProcessorScope(parentComponentModel)) {
                componentLocation = this.processFlowDirectChild(componentModel, parentComponentLocation, typedComponentIdentifier);
            } else if (this.isMunitFlowIdentifier(parentComponentModel)) {
                componentLocation = parentComponentLocation.appendRoutePart().appendLocationPart(this.findNonProcessorPath(componentModel), typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
            } else if (ComponentModelHelper.isErrorHandler(componentModel)) {
                componentLocation = this.processErrorHandlerComponent(componentModel, parentComponentLocation, typedComponentIdentifier);
            } else if (ComponentModelHelper.isTemplateOnErrorHandler(componentModel)) {
                componentLocation = this.processOnErrorModel(componentModel, parentComponentLocation, typedComponentIdentifier);
            } else if (this.parentComponentIsRouter(componentModel)) {
                componentLocation = this.isRoute(componentModel) ? parentComponentLocation.appendRoutePart().appendLocationPart(this.findNonProcessorPath(componentModel), Optional.of(TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.SCOPE).identifier(ROUTE_COMPONENT_IDENTIFIER).build()), componentModel.getConfigFileName(), componentModel.getLineNumber()) : (ComponentModelHelper.isProcessor(componentModel) ? parentComponentLocation.appendRoutePart().appendLocationPart(this.findProcessorPath(componentModel), Optional.empty(), Optional.empty(), Optional.empty()).appendProcessorsPart().appendLocationPart("0", typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber()) : parentComponentLocation.appendRoutePart().appendLocationPart(this.findNonProcessorPath(componentModel), Optional.of(TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.UNKNOWN).identifier(ROUTE_COMPONENT_IDENTIFIER).build()), Optional.empty(), Optional.empty()));
            } else if (ComponentModelHelper.isProcessor(componentModel)) {
                if (this.isModuleOperation(componentModel.getParent())) {
                    Optional<TypedComponentIdentifier> operationTypedIdentifier = ApplicationModel.MODULE_OPERATION_CHAIN.equals(typedComponentIdentifier.get().getIdentifier()) ? this.getModuleOperationTypeComponentIdentifier(componentModel) : typedComponentIdentifier;
                    componentLocation = this.processModuleOperationChildren(componentModel, operationTypedIdentifier);
                } else {
                    componentLocation = parentComponentLocation.appendProcessorsPart().appendLocationPart(this.findProcessorPath(componentModel), typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
                }
            } else {
                componentLocation = this.isBatchAggregator(componentModel) ? parentComponentLocation.appendLocationPart(BATCH_AGGREGATOR_COMPONENT_IDENTIFIER.getName(), Optional.of(TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.UNKNOWN).identifier(BATCH_AGGREGATOR_COMPONENT_IDENTIFIER).build()), componentModel.getConfigFileName(), componentModel.getLineNumber()) : parentComponentLocation.appendLocationPart(this.findNonProcessorPath(componentModel), typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
            }
        } else {
            DefaultComponentLocation parentComponentLocation = componentModel.getParent().getComponentLocation();
            componentLocation = parentComponentLocation.appendLocationPart(this.findNonProcessorPath(componentModel), typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
        }
        componentModel.setComponentLocation(componentLocation);
    }

    private boolean isBatchAggregator(ComponentModel componentModel) {
        return BATCH_AGGREGATOR_COMPONENT_IDENTIFIER.equals(componentModel.getIdentifier());
    }

    private boolean isRoute(ComponentModel componentModel) {
        return componentModel.getIdentifier().equals(ROUTE_COMPONENT_IDENTIFIER) || componentModel.getIdentifier().equals(CHOICE_WHEN_COMPONENT_IDENTIFIER) || componentModel.getIdentifier().equals(CHOICE_OTHERWISE_COMPONENT_IDENTIFIER) || componentModel.getIdentifier().equals(BATCH_PROCESSS_RECORDS_COMPONENT_IDENTIFIER) || componentModel.getIdentifier().equals(BATCH_ON_COMPLETE_IDENTIFIER) || componentModel.getIdentifier().equals(BATCH_STEP_COMPONENT_IDENTIFIER);
    }

    private boolean isHttpProxyPart(ComponentModel componentModel) {
        return componentModel.getIdentifier().equals(ApplicationModel.HTTP_PROXY_SOURCE_POLICY_IDENTIFIER) || componentModel.getIdentifier().equals(ApplicationModel.HTTP_PROXY_OPERATION_IDENTIFIER);
    }

    private boolean isMunitFlowIdentifier(ComponentModel componentModel) {
        return componentModel.getIdentifier().equals(ApplicationModel.MUNIT_TEST_IDENTIFIER);
    }

    private boolean isRootProcessorScope(ComponentModel componentModel) {
        ComponentIdentifier identifier = componentModel.getIdentifier();
        return identifier.equals(ApplicationModel.FLOW_IDENTIFIER) || identifier.equals(ApplicationModel.MUNIT_BEFORE_SUITE_IDENTIFIER) || identifier.equals(ApplicationModel.MUNIT_BEFORE_TEST_IDENTIFIER) || identifier.equals(ApplicationModel.MUNIT_AFTER_SUITE_IDENTIFIER) || identifier.equals(ApplicationModel.MUNIT_AFTER_TEST_IDENTIFIER);
    }

    private boolean isModuleOperation(ComponentModel componentModel) {
        return componentModel.getIdentifier().equals(ApplicationModel.MODULE_OPERATION_CHAIN);
    }

    private boolean parentComponentIsRouter(ComponentModel componentModel) {
        return this.existsWithinRouter(componentModel) && ComponentModelHelper.isRouter(componentModel.getParent());
    }

    private boolean existsWithinRouter(ComponentModel componentModel) {
        while (componentModel.getParent() != null) {
            if (ComponentModelHelper.isRouter(componentModel)) {
                return true;
            }
            componentModel = componentModel.getParent();
        }
        return false;
    }

    private String findNonProcessorPath(ComponentModel componentModel) {
        int i = 0;
        for (ComponentModel child : componentModel.getParent().getInnerComponents()) {
            if (child == componentModel) break;
            ++i;
        }
        return String.valueOf(i);
    }

    private DefaultComponentLocation processOnErrorModel(ComponentModel componentModel, DefaultComponentLocation parentComponentLocation, Optional<TypedComponentIdentifier> typedComponentIdentifier) {
        ComponentModel parentComponentModel = componentModel.getParent();
        int i = 0;
        for (ComponentModel childComponent : parentComponentModel.getInnerComponents()) {
            if (childComponent == componentModel) break;
            ++i;
        }
        return parentComponentLocation.appendLocationPart(String.valueOf(i), typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
    }

    private DefaultComponentLocation processFlowDirectChild(ComponentModel componentModel, DefaultComponentLocation parentComponentLocation, Optional<TypedComponentIdentifier> typedComponentIdentifier) {
        DefaultComponentLocation componentLocation;
        if (ComponentModelHelper.isMessageSource(componentModel)) {
            componentLocation = parentComponentLocation.appendLocationPart("source", typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
        } else if (ComponentModelHelper.isProcessor(componentModel)) {
            if (this.isModuleOperation(componentModel)) {
                typedComponentIdentifier = this.getModuleOperationTypeComponentIdentifier(componentModel);
            }
            componentLocation = parentComponentLocation.appendLocationPart(PROCESSORS_PART_NAME, Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart(this.findProcessorPath(componentModel), typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
        } else {
            componentLocation = ComponentModelHelper.isErrorHandler(componentModel) ? this.processErrorHandlerComponent(componentModel, parentComponentLocation, typedComponentIdentifier) : parentComponentLocation.appendLocationPart(this.findNonProcessorPath(componentModel), typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
        }
        return componentLocation;
    }

    private Optional<TypedComponentIdentifier> getModuleOperationTypeComponentIdentifier(ComponentModel componentModel) {
        ComponentIdentifier originalIdentifier = (ComponentIdentifier)componentModel.getCustomAttributes().get("ORIGINAL_IDENTIFIER");
        String namespace = originalIdentifier.getNamespace();
        String operationName = originalIdentifier.getName();
        ComponentIdentifier operationIdentifier = ComponentIdentifier.builder().namespace(namespace).name(operationName).build();
        return Optional.of(TypedComponentIdentifier.builder().identifier(operationIdentifier).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    }

    private DefaultComponentLocation processModuleOperationChildren(ComponentModel componentModel, Optional<TypedComponentIdentifier> operationTypedIdentifier) {
        Optional<TypedComponentIdentifier> parentOperationTypedIdentifier = this.getModuleOperationTypeComponentIdentifier(componentModel.getParent());
        String operationName = parentOperationTypedIdentifier.get().getIdentifier().getName();
        return new DefaultComponentLocation(Optional.of(operationName), Collections.emptyList()).appendLocationPart(operationName, parentOperationTypedIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber()).appendLocationPart(PROCESSORS_PART_NAME, Optional.empty(), Optional.empty(), Optional.empty()).appendLocationPart(this.findProcessorPath(componentModel), operationTypedIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
    }

    private DefaultComponentLocation processErrorHandlerComponent(ComponentModel componentModel, DefaultComponentLocation parentComponentLocation, Optional<TypedComponentIdentifier> typedComponentIdentifier) {
        DefaultComponentLocation componentLocation = parentComponentLocation.appendLocationPart("errorHandler", typedComponentIdentifier, componentModel.getConfigFileName(), componentModel.getLineNumber());
        return componentLocation;
    }

    private String findProcessorPath(ComponentModel componentModel) {
        ComponentModel processorModel;
        ComponentModel parentComponentModel = componentModel.getParent();
        List processorModels = parentComponentModel.getInnerComponents().stream().filter(ComponentModelHelper::isProcessor).collect(Collectors.toList());
        int i = 0;
        Iterator iterator = processorModels.iterator();
        while (iterator.hasNext() && (processorModel = (ComponentModel)iterator.next()) != componentModel) {
            ++i;
        }
        return String.valueOf(i);
    }

    private boolean existsWithinRootContainer(ComponentModel componentModel) {
        return this.existsWithin(componentModel, ApplicationModel.FLOW_IDENTIFIER) || this.existsWithin(componentModel, ApplicationModel.MUNIT_TEST_IDENTIFIER) || this.existsWithin(componentModel, ApplicationModel.MUNIT_BEFORE_SUITE_IDENTIFIER) || this.existsWithin(componentModel, ApplicationModel.MUNIT_BEFORE_TEST_IDENTIFIER) || this.existsWithin(componentModel, ApplicationModel.MUNIT_AFTER_SUITE_IDENTIFIER) || this.existsWithin(componentModel, ApplicationModel.MUNIT_AFTER_TEST_IDENTIFIER) || this.existsWithin(componentModel, ApplicationModel.HTTP_PROXY_POLICY_IDENTIFIER);
    }

    private boolean existsWithinSubflow(ComponentModel componentModel) {
        return this.existsWithin(componentModel, ApplicationModel.SUBFLOW_IDENTIFIER);
    }

    private boolean existsWithin(ComponentModel componentModel, ComponentIdentifier componentIdentifier) {
        while (componentModel.getParent() != null) {
            if (componentModel.getParent().getIdentifier().equals(componentIdentifier)) {
                return true;
            }
            componentModel = componentModel.getParent();
        }
        return false;
    }
}

