/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.artifact.api.descriptor.LoaderNotFoundException;

public abstract class AbstractArtifactDescriptorFactory<M extends AbstractMuleArtifactModel, T extends ArtifactDescriptor>
implements ArtifactDescriptorFactory<T> {
    public static final String ARTIFACT_DESCRIPTOR_DOES_NOT_EXISTS_ERROR = "Artifact descriptor does not exists: ";
    protected final DescriptorLoaderRepository descriptorLoaderRepository;

    public AbstractArtifactDescriptorFactory(DescriptorLoaderRepository descriptorLoaderRepository) {
        Preconditions.checkArgument((descriptorLoaderRepository != null ? 1 : 0) != 0, (String)"descriptorLoaderRepository cannot be null");
        this.descriptorLoaderRepository = descriptorLoaderRepository;
    }

    @Override
    public T create(File artifactFolder) throws ArtifactDescriptorCreateException {
        File artifactJsonFile = new File(artifactFolder, ArtifactDescriptor.MULE_ARTIFACT_FOLDER + File.separator + this.getDescriptorFileName());
        if (!artifactJsonFile.exists()) {
            throw new ArtifactDescriptorCreateException(ARTIFACT_DESCRIPTOR_DOES_NOT_EXISTS_ERROR + artifactJsonFile);
        }
        T artifactDescriptor = this.loadFromJsonDescriptor(artifactFolder, this.loadModelFromJson(this.getDescriptorContent(artifactJsonFile)));
        return artifactDescriptor;
    }

    protected abstract ArtifactType getArtifactType();

    protected final T loadFromJsonDescriptor(File artifactLocation, M artifactModel) {
        T descriptor = this.createArtifactDescriptor(artifactLocation, artifactModel.getName());
        if (artifactLocation.isDirectory()) {
            ((ArtifactDescriptor)descriptor).setRootFolder(artifactLocation);
        }
        ((ArtifactDescriptor)descriptor).setBundleDescriptor(this.getBundleDescriptor(artifactLocation, artifactModel));
        ((ArtifactDescriptor)descriptor).setMinMuleVersion(new MuleVersion(artifactModel.getMinMuleVersion()));
        ((ArtifactDescriptor)descriptor).setRequiredProduct(artifactModel.getRequiredProduct());
        ClassLoaderModel classLoaderModel = this.getClassLoaderModel(artifactLocation, artifactModel.getClassLoaderModelLoaderDescriptor());
        ((ArtifactDescriptor)descriptor).setClassLoaderModel(classLoaderModel);
        this.doDescriptorConfig(artifactModel, descriptor, artifactLocation);
        this.validate(descriptor);
        return descriptor;
    }

    private void validate(T descriptor) {
        MuleVersion minMuleVersion = ((ArtifactDescriptor)descriptor).getMinMuleVersion();
        Preconditions.checkState((minMuleVersion != null ? 1 : 0) != 0, (String)String.format("The artifact %s does not specifies a minMuleVersion", ((ArtifactDescriptor)descriptor).getName()));
        MuleVersion runtimeVersion = new MuleVersion(MuleManifest.getProductVersion());
        runtimeVersion = new MuleVersion(runtimeVersion.toCompleteNumericVersion().replace("-" + runtimeVersion.getSuffix(), ""));
        if (runtimeVersion.priorTo(minMuleVersion)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Artifact %s requires a newest runtime version. Artifact required version is %s and Mule Runtime version is %s", (Object[])new Object[]{((ArtifactDescriptor)descriptor).getName(), ((ArtifactDescriptor)descriptor).getMinMuleVersion().toCompleteNumericVersion(), runtimeVersion.toCompleteNumericVersion()}));
        }
        Product requiredProduct = ((ArtifactDescriptor)descriptor).getRequiredProduct();
        Preconditions.checkState((requiredProduct != null ? 1 : 0) != 0, (String)String.format("The artifact %s does not specifies a requiredProduct", ((ArtifactDescriptor)descriptor).getName()));
        Product runtimeProduct = Product.getProductByName((String)MuleManifest.getProductName());
        if (!runtimeProduct.supports(requiredProduct)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The artifact %s requires a different runtime. The artifact required runtime is %s and the runtime is %s", (Object[])new Object[]{((ArtifactDescriptor)descriptor).getName(), ((ArtifactDescriptor)descriptor).getRequiredProduct().name(), runtimeProduct.name()}));
        }
    }

    protected M loadModelFromJson(String jsonString) {
        try {
            return this.deserializeArtifactModel(jsonString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot deserialize artifact descriptor from: " + jsonString);
        }
    }

    protected abstract AbstractMuleArtifactModelJsonSerializer<M> getMuleArtifactModelJsonSerializer();

    protected abstract void doDescriptorConfig(M var1, T var2, File var3);

    protected abstract T createArtifactDescriptor(File var1, String var2);

    private String getDescriptorFileName() {
        return "mule-artifact.json";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDescriptorContent(File jsonFile) {
        try (FileInputStream stream = new FileInputStream(jsonFile);){
            String string = IOUtils.toString((InputStream)stream);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not read extension describer on artifact '%s'", jsonFile.getAbsolutePath()), e);
        }
    }

    private ClassLoaderModel getClassLoaderModel(File artifactFolder, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor) {
        ClassLoaderModel classLoaderModel;
        ClassLoaderModelLoader classLoaderModelLoader;
        try {
            classLoaderModelLoader = this.descriptorLoaderRepository.get(classLoaderModelLoaderDescriptor.getId(), this.getArtifactType(), ClassLoaderModelLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(AbstractArtifactDescriptorFactory.invalidClassLoaderModelIdError(artifactFolder, classLoaderModelLoaderDescriptor));
        }
        try {
            classLoaderModel = (ClassLoaderModel)classLoaderModelLoader.load(artifactFolder, classLoaderModelLoaderDescriptor.getAttributes(), this.getArtifactType());
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException(e);
        }
        return classLoaderModel;
    }

    private BundleDescriptor getBundleDescriptor(File appFolder, M artifactModel) {
        BundleDescriptorLoader bundleDescriptorLoader;
        try {
            bundleDescriptorLoader = this.descriptorLoaderRepository.get(artifactModel.getBundleDescriptorLoader().getId(), this.getArtifactType(), BundleDescriptorLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(AbstractArtifactDescriptorFactory.invalidBundleDescriptorLoaderIdError(appFolder, artifactModel.getBundleDescriptorLoader()));
        }
        try {
            return (BundleDescriptor)bundleDescriptorLoader.load(appFolder, artifactModel.getBundleDescriptorLoader().getAttributes(), this.getArtifactType());
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException(e);
        }
    }

    private M deserializeArtifactModel(String jsonString) throws IOException {
        return (M)this.getMuleArtifactModelJsonSerializer().deserialize(jsonString);
    }

    public static String invalidClassLoaderModelIdError(File artifactFolder, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor) {
        return String.format("The identifier '%s' for a class loader model descriptor is not supported (error found while reading artifact '%s')", classLoaderModelLoaderDescriptor.getId(), artifactFolder.getAbsolutePath());
    }

    public static String invalidBundleDescriptorLoaderIdError(File artifactFolder, MuleArtifactLoaderDescriptor bundleDescriptorLoader) {
        return String.format("The identifier '%s' for a bundle descriptor loader is not supported (error found while reading artifact '%s')", bundleDescriptorLoader.getId(), artifactFolder.getAbsolutePath());
    }
}

