/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.api.application;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public class ApplicationDescriptor
extends DeployableArtifactDescriptor {
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "mule-config.xml";
    public static final String REPOSITORY_FOLDER = "repository";
    public static final String MULE_APPLICATION_CLASSIFIER = "mule-application";
    private String encoding;
    private Map<String, String> appProperties = new HashMap<String, String>();
    private File logConfigFile;
    private ArtifactDeclaration artifactDeclaration;
    private Optional<BundleDescriptor> domainDescriptor;

    public ApplicationDescriptor(String name) {
        super(name);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map<String, String> getAppProperties() {
        return this.appProperties;
    }

    public void setAppProperties(Map<String, String> appProperties) {
        this.appProperties = appProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<BundleDescriptor> getDomainDescriptor() {
        if (this.domainDescriptor == null) {
            ApplicationDescriptor applicationDescriptor = this;
            synchronized (applicationDescriptor) {
                if (this.domainDescriptor == null) {
                    Optional<BundleDependency> domain = this.getClassLoaderModel().getDependencies().stream().filter(d -> d.getDescriptor().getClassifier().isPresent() ? ((String)d.getDescriptor().getClassifier().get()).equals("mule-domain") : false).findFirst();
                    this.domainDescriptor = domain.isPresent() ? Optional.ofNullable(domain.get().getDescriptor()) : Optional.empty();
                }
            }
        }
        return this.domainDescriptor;
    }

    public void setLogConfigFile(File logConfigFile) {
        this.logConfigFile = logConfigFile;
    }

    public File getLogConfigFile() {
        return this.logConfigFile;
    }

    public ArtifactDeclaration getArtifactDeclaration() {
        return this.artifactDeclaration;
    }

    public void setArtifactDeclaration(ArtifactDeclaration artifactDeclaration) {
        this.artifactDeclaration = artifactDeclaration;
    }

    @Override
    protected List<String> getDefaultConfigResources() {
        return ImmutableList.builder().add((Object)DEFAULT_CONFIGURATION_RESOURCE).build();
    }
}

