/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.packager.sources.ContentGenerator;
import org.mule.tools.api.packager.structure.FolderNames;
import org.mule.tools.api.util.CopyFileVisitor;

public class MuleContentGenerator
extends ContentGenerator {
    public MuleContentGenerator(ProjectInformation projectInformation) {
        super(projectInformation);
    }

    @Override
    public void createContent() throws IOException {
        this.createMetaInfMuleSourceFolderContent();
        this.createDescriptors();
    }

    public void createMuleSrcFolderContent() throws IOException {
        Path originPath = PackagingType.fromString(this.projectInformation.getPackaging()).getSourceFolderLocation(this.projectInformation.getProjectBaseFolder());
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.CLASSES.value());
        this.copyContent(originPath, destinationPath, Optional.ofNullable(null), true, false);
    }

    public void createTestFolderContent() throws IOException {
        Path originPath = PackagingType.fromString(this.projectInformation.getPackaging()).getTestSourceFolderLocation(this.projectInformation.getProjectBaseFolder());
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.TEST_MULE.value()).resolve(originPath.getFileName());
        this.copyContent(originPath, destinationPath, Optional.ofNullable(null), false, true);
    }

    public void createMetaInfMuleSourceFolderContent() throws IOException {
        Path originPath = this.projectInformation.getProjectBaseFolder();
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_SRC.value()).resolve(this.projectInformation.getArtifactId());
        ArrayList<Path> exclusions = new ArrayList<Path>();
        exclusions.add(this.projectInformation.getProjectBaseFolder().resolve(FolderNames.TARGET.value()));
        this.copyContent(originPath, destinationPath, Optional.of(exclusions));
    }

    public void createApplicationClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel) {
        File destinationFolder = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).toFile();
        MuleContentGenerator.createClassLoaderModelJsonFile(classLoaderModel, destinationFolder);
    }

    public static ClassLoaderModel createClassLoaderModelFromJson(File classLoaderModelDescriptor) {
        return ClassLoaderModelJsonSerializer.deserialize((File)classLoaderModelDescriptor);
    }

    private void copyContent(Path originPath, Path destinationPath, Optional<List<Path>> exclusions) throws IOException {
        this.copyContent(originPath, destinationPath, exclusions, true, true);
    }

    private void copyContent(Path originPath, Path destinationPath, Optional<List<Path>> exclusions, Boolean validateOrigin, Boolean validateDestination) throws IOException {
        if (validateOrigin.booleanValue()) {
            MuleContentGenerator.checkPathExist(originPath);
        }
        if (validateDestination.booleanValue()) {
            MuleContentGenerator.checkPathExist(destinationPath);
        }
        CopyFileVisitor visitor = new CopyFileVisitor(originPath.toFile(), destinationPath.toFile());
        exclusions.ifPresent(e -> visitor.setExclusions((List<Path>)e));
        Files.walkFileTree(originPath, visitor);
    }

    public static File createClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel, File destinationFolder) {
        return ClassLoaderModelJsonSerializer.serializeToFile((ClassLoaderModel)classLoaderModel, (File)destinationFolder);
    }
}

