/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthManager;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public abstract class ComponentMessageProcessorBuilder<M extends ComponentModel, P extends ExtensionComponent> {
    protected final ExtensionModel extensionModel;
    protected final M operationModel;
    protected final PolicyManager policyManager;
    protected final MuleContext muleContext;
    protected Registry registry;
    protected final ExtensionConnectionSupplier extensionConnectionSupplier;
    protected final ExtensionsOAuthManager oauthManager;
    protected ConfigurationProvider configurationProvider;
    protected Map<String, ?> parameters;
    protected String target;
    protected String targetValue;
    protected CursorProviderFactory cursorProviderFactory;
    protected RetryPolicyTemplate retryPolicyTemplate;

    public ComponentMessageProcessorBuilder(ExtensionModel extensionModel, M operationModel, PolicyManager policyManager, MuleContext muleContext, Registry registry) {
        Preconditions.checkArgument((extensionModel != null ? 1 : 0) != 0, (String)"ExtensionModel cannot be null");
        Preconditions.checkArgument((operationModel != null ? 1 : 0) != 0, (String)"OperationModel cannot be null");
        Preconditions.checkArgument((policyManager != null ? 1 : 0) != 0, (String)"PolicyManager cannot be null");
        Preconditions.checkArgument((muleContext != null ? 1 : 0) != 0, (String)"muleContext cannot be null");
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.policyManager = policyManager;
        this.muleContext = muleContext;
        this.registry = registry;
        this.extensionConnectionSupplier = (ExtensionConnectionSupplier)registry.lookupByType(ExtensionConnectionSupplier.class).get();
        this.oauthManager = (ExtensionsOAuthManager)registry.lookupByType(ExtensionsOAuthManager.class).get();
    }

    public P build() {
        return (P)((Object)((ExtensionComponent)((Object)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> {
            try {
                ExtensionManager extensionManager = this.muleContext.getExtensionManager();
                ResolverSet operationArguments = this.getArgumentsResolverSet();
                P processor = this.createMessageProcessor(extensionManager, operationArguments);
                this.muleContext.getInjector().inject(processor);
                return processor;
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }))));
    }

    protected abstract P createMessageProcessor(ExtensionManager var1, ResolverSet var2);

    protected ResolverSet getArgumentsResolverSet() throws ConfigurationException {
        ResolverSet parametersResolverSet = ParametersResolver.fromValues(this.parameters, this.muleContext).getParametersAsResolverSet((ParameterizedModel)this.operationModel, this.muleContext);
        ResolverSet childsResolverSet = ParametersResolver.fromValues(this.parameters, this.muleContext).getNestedComponentsAsResolverSet((ComponentModel)this.operationModel);
        return parametersResolverSet.merge(childsResolverSet);
    }

    public ComponentMessageProcessorBuilder<M, P> setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setParameters(Map<String, ?> parameters) {
        this.parameters = parameters != null ? parameters : new HashMap();
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setTarget(String target) {
        this.target = target;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setTargetValue(String targetValue) {
        this.targetValue = targetValue;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setCursorProviderFactory(CursorProviderFactory cursorProviderFactory) {
        this.cursorProviderFactory = cursorProviderFactory;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setNestedProcessors(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
        return this;
    }
}

