/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.structure.FolderNames;

public class DefaultValuesMuleArtifactJsonGenerator {
    private static final MuleApplicationModelJsonSerializer serializer = new MuleApplicationModelJsonSerializer();
    private static final String MULE_ID = "mule";

    public static void generate(Path projectBaseFolder) throws IOException {
        Path muleArtifactJsonLocation = DefaultValuesMuleArtifactJsonGenerator.resolveMuleArtifactJsonLocation(projectBaseFolder);
        MuleArtifactContentResolver muleArtifactContentResolver = new MuleArtifactContentResolver(projectBaseFolder);
        DefaultValuesMuleArtifactJsonGenerator.generate(muleArtifactJsonLocation, muleArtifactJsonLocation, muleArtifactContentResolver);
    }

    protected static Path resolveMuleArtifactJsonLocation(Path projectBaseFolder) {
        return projectBaseFolder.resolve(FolderNames.TARGET.value()).resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value());
    }

    protected static void generate(Path originFolder, Path destinationFolder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModel originalMuleArtifact = DefaultValuesMuleArtifactJsonGenerator.getOriginalMuleArtifact(originFolder);
        MuleApplicationModel generatedMuleArtifact = DefaultValuesMuleArtifactJsonGenerator.generateMuleArtifactWithDefaultValues(originalMuleArtifact, muleArtifactContentResolver);
        DefaultValuesMuleArtifactJsonGenerator.writeMuleArtifactToFile(generatedMuleArtifact, destinationFolder);
    }

    protected static void writeMuleArtifactToFile(MuleApplicationModel muleArtifact, Path destinationFolder) throws IOException {
        String generatedMuleArtifactJsonContent = serializer.serialize((AbstractMuleArtifactModel)muleArtifact);
        File generatedMuleArtifactJson = new File(destinationFolder.toFile(), "mule-artifact.json");
        FileUtils.writeStringToFile((File)generatedMuleArtifactJson, (String)generatedMuleArtifactJsonContent, (String)null);
    }

    protected static MuleApplicationModel getOriginalMuleArtifact(Path originFolder) throws IOException {
        File originalMuleArtifactJsonFile = originFolder.resolve("mule-artifact.json").toFile();
        return (MuleApplicationModel)serializer.deserialize(FileUtils.readFileToString((File)originalMuleArtifactJsonFile, (String)null));
    }

    protected static MuleApplicationModel generateMuleArtifactWithDefaultValues(MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModel.MuleApplicationModelBuilder builder = DefaultValuesMuleArtifactJsonGenerator.getBuilderWithRequiredValues(originalMuleArtifact);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultValuesNotPresent(builder, originalMuleArtifact, muleArtifactContentResolver);
        return (MuleApplicationModel)builder.build();
    }

    protected static void setBuilderWithDefaultValuesNotPresent(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultRedeploymentEnabled(builder, originalMuleArtifact);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultConfigsValue(builder, originalMuleArtifact, muleArtifactContentResolver);
    }

    protected static void setBuilderWithDefaultExportedResourcesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        Map originalAttributes = descriptorLoader.getAttributes();
        HashMap<String, List<String>> attributesCopy = new HashMap<String, List<String>>();
        if (originalAttributes != null) {
            attributesCopy.putAll(originalAttributes);
        }
        attributesCopy.putIfAbsent("exportedResources", muleArtifactContentResolver.getExportedResources());
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
    }

    protected static void setBuilderWithDefaultExportedPackagesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        Map originalAttributes = descriptorLoader.getAttributes();
        HashMap<String, List<String>> attributesCopy = new HashMap<String, List<String>>();
        if (originalAttributes != null) {
            attributesCopy.putAll(originalAttributes);
        }
        attributesCopy.putIfAbsent("exportedPackages", muleArtifactContentResolver.getExportedPackages());
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
    }

    protected static void setBuilderWithDefaultConfigsValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        List<Object> configs;
        try {
            Field configsField = originalMuleArtifact.getClass().getSuperclass().getDeclaredField("configs");
            configsField.setAccessible(true);
            configs = (List<Object>)configsField.get(originalMuleArtifact);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            configs = muleArtifactContentResolver.getConfigs();
        }
        builder.setConfigs(configs != null ? configs : muleArtifactContentResolver.getConfigs());
    }

    protected static void setBuilderWithDefaultRedeploymentEnabled(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        builder.setRedeploymentEnabled(originalMuleArtifact.isRedeploymentEnabled());
    }

    protected static void setBuilderWithDefaultBundleDescriptorLoaderValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        MuleArtifactLoaderDescriptor bundleDescriptorLoader = originalMuleArtifact.getBundleDescriptorLoader();
        builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(MULE_ID, bundleDescriptorLoader == null || bundleDescriptorLoader.getAttributes() == null ? new HashMap() : bundleDescriptorLoader.getAttributes()));
    }

    protected static MuleApplicationModel.MuleApplicationModelBuilder getBuilderWithRequiredValues(MuleApplicationModel muleArtifact) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setName(muleArtifact.getName());
        builder.withClassLoaderModelDescriptorLoader(muleArtifact.getClassLoaderModelLoaderDescriptor());
        builder.setMinMuleVersion(muleArtifact.getMinMuleVersion());
        builder.setRequiredProduct(muleArtifact.getRequiredProduct());
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultBundleDescriptorLoaderValue(builder, muleArtifact);
        return builder;
    }
}

