/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.impl.dv.xs.EqualityHelper;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSOpenContentDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XS11AllCM;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.models.XSDFACM;
import org.apache.xerces.impl.xs.models.XSEmptyCM;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSNamedMap;

public final class XS11CMRestriction
implements XSElementDeclHelper {
    private final SubstitutionGroupHandler sgh;
    private final XSGrammarBucket gb;
    private final CMBuilder cmb;
    private final XSConstraints xsc;
    private XS11CM base;
    private XS11CM derived;
    private XS11AllCM allb;
    private XS11AllCM alld;
    private XSDFACM dfab;
    private final QName qname = new QName();
    private final List states = new ArrayList();
    private StatePair pair = null;
    private short wType;
    private final List wNSList = new ArrayList();
    private final List wNSListTemp = new ArrayList();
    private final List wDNList = new ArrayList();
    private boolean wDD;
    private boolean wDS;
    private final List wANList = new ArrayList();
    private List globals;
    private List siblingsB;
    private List siblingsD;
    private XSElementDecl eb;
    private XSElementDecl ed;
    private XSWildcardDecl wb;
    private XSWildcardDecl wd;
    private int[] b;
    private int[] bn;
    private int[] d;
    private int[] dn;
    private final int[] indexb = new int[1];
    private final int[] indexd = new int[1];
    private boolean matchedHead;

    public XS11CMRestriction(XSCMValidator base, XSCMValidator derived, SubstitutionGroupHandler sgh, XSGrammarBucket gb, CMBuilder cmb, XSConstraints xsc) {
        this.base = (XS11CM)base;
        this.derived = (XS11CM)derived;
        this.sgh = sgh;
        this.gb = gb;
        this.cmb = cmb;
        this.xsc = xsc;
    }

    private void addState() {
        this.derived.optimizeStates(this.base, this.bn, this.dn, this.indexb[0]);
        if (this.pair == null) {
            this.pair = new StatePair(this.bn, this.dn);
        } else {
            this.pair.set(this.bn, this.dn);
        }
        if (!this.states.contains(this.pair)) {
            this.states.add(this.pair);
            this.pair = null;
        }
    }

    private void copyDerivedWildcard() {
        int i;
        int size;
        this.wType = this.wd.fType;
        this.wDD = this.wd.fDisallowedDefined;
        this.wDS = this.wd.fDisallowedSibling;
        this.wNSList.clear();
        if (this.wType == 1) {
            this.wType = (short)2;
        } else {
            size = this.wd.fNamespaceList == null ? 0 : this.wd.fNamespaceList.length;
            for (i = 0; i < size; ++i) {
                this.wNSList.add(this.wd.fNamespaceList[i]);
            }
        }
        size = this.wd.fDisallowedNamesList == null ? 0 : this.wd.fDisallowedNamesList.length;
        for (i = 0; i < size; ++i) {
            this.wDNList.add(this.wd.fDisallowedNamesList[i].uri);
            this.wDNList.add(this.wd.fDisallowedNamesList[i].localpart);
        }
        this.wANList.clear();
    }

    private void addAN(String ns, String name) {
        if (!this.allowNS(ns)) {
            return;
        }
        int i = 0;
        while (i < this.wDNList.size()) {
            if (this.wDNList.get(i++) != ns || this.wDNList.get(i++) != name) continue;
            return;
        }
        this.qname.uri = ns;
        this.qname.localpart = name;
        if (!this.derived.allowExpandedName(this.wd, this.qname, this.sgh, this)) {
            return;
        }
        this.wANList.add(ns);
        this.wANList.add(name);
    }

    private boolean allowNS(String ns) {
        return this.wType == 1 || this.wType == 2 && !this.wNSList.contains(ns) || this.wType == 3 && this.wNSList.contains(ns);
    }

    private boolean allowName(String ns, String name) {
        int i;
        if (!this.allowNS(ns)) {
            return false;
        }
        for (i = 0; i < this.wDNList.size(); i += 2) {
            if (ns != this.wDNList.get(i) || name != this.wDNList.get(i + 1)) continue;
            return false;
        }
        for (i = 0; i < this.wANList.size(); i += 2) {
            if (ns != this.wANList.get(i) || name != this.wANList.get(i + 1)) continue;
            return true;
        }
        this.qname.uri = ns;
        this.qname.localpart = name;
        return this.derived.allowExpandedName(this.wd, this.qname, this.sgh, this);
    }

    private boolean emptyWildcard() {
        return this.wType == 3 && this.wNSList.size() == 0 && this.wANList.size() == 0;
    }

    private void getGlobalElements() {
        this.globals = new ArrayList();
        SchemaGrammar[] sgs = this.gb.getGrammars();
        for (int i = 0; i < sgs.length; ++i) {
            this.addGlobals(sgs[i]);
        }
    }

    private void addGlobals(SchemaGrammar g) {
        XSNamedMap map = g.getComponents((short)2);
        for (int i = 0; i < map.getLength(); ++i) {
            XSElementDecl e = (XSElementDecl)map.item(i);
            this.globals.add(e.fTargetNamespace);
            this.globals.add(e.fName);
        }
    }

    private void getBaseSiblings() {
        this.siblingsB = this.base.getDefinedNames(this.sgh);
    }

    private void getDerivedSiblings() {
        this.siblingsD = this.derived.getDefinedNames(this.sgh);
    }

    @Override
    public XSElementDecl getGlobalElementDecl(QName name) {
        SchemaGrammar sg = this.gb.getGrammar(name.uri);
        return sg != null ? sg.getGlobalElementDecl(name.localpart) : null;
    }

    public boolean check() {
        this.b = this.base.startContentModel();
        this.bn = this.base.startContentModel();
        this.d = this.derived.startContentModel();
        this.dn = this.derived.startContentModel();
        if (this.derived instanceof XS11AllCM) {
            this.alld = (XS11AllCM)this.derived;
            Boolean res = this.checkAllDerived();
            if (res != null) {
                return res;
            }
        }
        ArrayList<String> excludedElementsCopy = new ArrayList<String>();
        int pos = 0;
        StatePair p = new StatePair(this.b, this.d);
        this.states.add(p);
        while (pos < this.states.size()) {
            StatePair sp = (StatePair)this.states.get(pos++);
            sp.getStates(this.b, this.d);
            excludedElementsCopy.clear();
            this.indexd[0] = -1;
            while ((this.ed = this.derived.nextElementTransition(this.d, this.dn, this.indexd)) != null) {
                excludedElementsCopy.add(this.ed.fTargetNamespace);
                excludedElementsCopy.add(this.ed.fName);
                if (this.ed.getScope() == 1) {
                    XSElementDecl[] eds = this.sgh.getSubstitutionGroup(this.ed, (short)4);
                    for (int j = 0; j < eds.length; ++j) {
                        excludedElementsCopy.add(eds[j].fTargetNamespace);
                        excludedElementsCopy.add(eds[j].fName);
                    }
                }
                if (this.matchElementInBase()) continue;
                return false;
            }
            this.indexd[0] = -1;
            while ((this.wd = this.derived.nextWildcardTransition(this.d, this.dn, this.indexd)) != null) {
                this.wDNList.clear();
                this.wDNList.addAll(excludedElementsCopy);
                if (this.matchWildcardInBase()) continue;
                return false;
            }
        }
        return this.checkFinalStates();
    }

    private boolean matchElementInBase() {
        this.matchedHead = false;
        if (!this.findElementInBase()) {
            return false;
        }
        this.addState();
        if (this.matchedHead) {
            return true;
        }
        XSElementDecl[] eds = this.sgh.getSubstitutionGroup(this.ed, (short)4);
        for (int i = 0; i < eds.length; ++i) {
            this.ed = eds[i];
            if (!this.findElementInBase()) {
                return false;
            }
            this.addState();
        }
        return true;
    }

    private boolean findElementInBase() {
        this.indexb[0] = -1;
        while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            if (!this.matchElementWithBaseElement()) continue;
            return this.checkEERestriction();
        }
        this.indexb[0] = -1;
        while ((this.wb = this.base.nextWildcardTransition(this.b, this.bn, this.indexb)) != null) {
            this.qname.uri = this.ed.fTargetNamespace;
            this.qname.localpart = this.ed.fName;
            if (!this.base.allowExpandedName(this.wb, this.qname, this.sgh, this)) continue;
            return this.checkEWRestriction();
        }
        return false;
    }

    private boolean matchElementWithBaseElement() {
        if (this.eb.getName() == this.ed.getName() && this.eb.getNamespace() == this.ed.getNamespace()) {
            this.matchedHead = this.eb == this.ed;
            return true;
        }
        XSElementDecl[] ebs = this.sgh.getSubstitutionGroup(this.eb, (short)4);
        for (int i = 0; i < ebs.length; ++i) {
            if (ebs[i].getName() != this.ed.getName() || ebs[i].getNamespace() != this.ed.getNamespace()) continue;
            this.eb = ebs[i];
            return true;
        }
        return false;
    }

    private boolean checkEERestriction() {
        if (this.eb == this.ed) {
            return true;
        }
        if (!this.eb.getNillable() && this.ed.getNillable()) {
            return false;
        }
        if (this.eb.getConstraintType() == 2) {
            if (this.ed.getConstraintType() != 2) {
                return false;
            }
            if (!EqualityHelper.isEqual(this.eb.fDefault, this.ed.fDefault, (short)4)) {
                return false;
            }
        }
        if (!this.checkIDConstraintRestriction(this.ed, this.eb)) {
            return false;
        }
        if ((this.ed.fBlock & this.eb.fBlock) != this.eb.fBlock) {
            return false;
        }
        if (!this.xsc.checkTypeDerivationOk(this.ed.fType, this.eb.fType, (short)25)) {
            return false;
        }
        return !XS11TypeHelper.isTypeTablesComparable(this.eb.getTypeAlternatives(), this.ed.getTypeAlternatives()) || this.xsc.isTypeTablesEquivalent(this.eb, this.ed);
    }

    private boolean checkIDConstraintRestriction(XSElementDecl derivedElemDecl, XSElementDecl baseElemDecl) {
        IdentityConstraint[] idcd = derivedElemDecl.getIDConstraints();
        IdentityConstraint[] idcb = baseElemDecl.getIDConstraints();
        int sizeb = idcb == null ? 0 : idcb.length;
        int sized = idcd == null ? 0 : idcd.length;
        for (int b = 0; b < sizeb; ++b) {
            int d;
            for (d = 0; d < sized && idcb[b] != idcd[d]; ++d) {
            }
            if (d != idcd.length) continue;
            return false;
        }
        return true;
    }

    private boolean checkEWRestriction() {
        if (this.wb.getProcessContents() == 2) {
            return true;
        }
        this.qname.uri = this.ed.fTargetNamespace;
        this.qname.localpart = this.ed.fName;
        this.eb = this.getGlobalElementDecl(this.qname);
        if (this.eb == null) {
            return this.wb.getProcessContents() == 3;
        }
        return this.checkEERestriction();
    }

    private boolean matchWildcardInBase() {
        this.copyDerivedWildcard();
        if (this.derived.isOpenContent(this.wd)) {
            XSWildcardDecl wd1;
            int[] idx = new int[]{-1};
            while (!this.emptyWildcard() && (wd1 = this.derived.nextWildcardTransition(this.d, this.dn, idx)) != null) {
                if (wd1 == this.wd) continue;
                this.subtractWildcard(wd1, true);
            }
        }
        this.indexb[0] = -1;
        while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            Boolean res = this.checkWERestriction();
            if (res != null) {
                if (!res.booleanValue()) {
                    return false;
                }
                this.addState();
            }
            if (this.eb.getScope() != 1) continue;
            XSElementDecl[] ebs = this.sgh.getSubstitutionGroup(this.eb, (short)4);
            for (int j = 0; j < ebs.length; ++j) {
                this.eb = ebs[j];
                res = this.checkWERestriction();
                if (res == null) continue;
                if (!res.booleanValue()) {
                    return false;
                }
                this.addState();
            }
        }
        this.indexb[0] = -1;
        while (!this.emptyWildcard() && (this.wb = this.base.nextWildcardTransition(this.b, this.bn, this.indexb)) != null) {
            if (!this.subtractWildcard(this.wb, false)) continue;
            if (this.wd.weakerProcessContents(this.wb)) {
                return false;
            }
            this.addState();
        }
        return this.emptyWildcard();
    }

    private Boolean checkWERestriction() {
        if (!this.allowName(this.eb.fTargetNamespace, this.eb.fName)) {
            return null;
        }
        if (this.wd.fProcessContents == 2) {
            return Boolean.FALSE;
        }
        this.ed = this.getGlobalElementDecl(this.qname);
        if (this.ed == null) {
            return Boolean.FALSE;
        }
        if (this.ed != this.eb && !this.checkEERestriction()) {
            return Boolean.FALSE;
        }
        this.wDNList.add(this.eb.fTargetNamespace);
        this.wDNList.add(this.eb.fName);
        return Boolean.TRUE;
    }

    private boolean subtractWildcard(XSWildcardDecl wc, boolean isDerived) {
        String name;
        String ns;
        int i;
        boolean changed = false;
        if (!isDerived && this.base.isOpenContent(wc) && this.wANList.size() > 0) {
            int i2 = 0;
            while (i2 < this.wANList.size()) {
                this.qname.uri = (String)this.wANList.get(i2++);
                this.qname.localpart = (String)this.wANList.get(i2++);
                if (this.base.allowExpandedName(wc, this.qname, this.sgh, this)) continue;
                return false;
            }
            this.wANList.clear();
            changed = true;
        }
        int count = wc.fDisallowedNamesList == null ? 0 : wc.fDisallowedNamesList.length;
        for (i = 0; i < count; ++i) {
            this.addAN(wc.fDisallowedNamesList[i].uri, wc.fDisallowedNamesList[i].localpart);
        }
        if (wc.fDisallowedDefined && !this.wDD) {
            if (this.globals == null) {
                this.getGlobalElements();
            }
            i = 0;
            while (i < this.globals.size()) {
                ns = (String)this.globals.get(i++);
                name = (String)this.globals.get(i++);
                if (!wc.allowNamespace(ns)) continue;
                this.addAN(ns, name);
            }
        }
        if (wc.fDisallowedSibling) {
            if (!isDerived) {
                if (this.siblingsB == null) {
                    this.getBaseSiblings();
                }
                i = 0;
                while (i < this.siblingsB.size()) {
                    ns = (String)this.siblingsB.get(i++);
                    name = (String)this.siblingsB.get(i++);
                    if (!wc.allowNamespace(ns)) continue;
                    this.addAN(ns, name);
                }
            } else if (!this.wDS) {
                if (this.siblingsD == null) {
                    this.getDerivedSiblings();
                }
                i = 0;
                while (i < this.siblingsD.size()) {
                    ns = (String)this.siblingsD.get(i++);
                    name = (String)this.siblingsD.get(i++);
                    if (!wc.allowNamespace(ns)) continue;
                    this.addAN(ns, name);
                }
            }
        }
        if (wc.getConstraintType() == 1) {
            this.wType = (short)3;
            this.wNSList.clear();
            return true;
        }
        if (wc.getConstraintType() == 2) {
            if (this.wType == 2) {
                this.wType = (short)3;
                this.wNSListTemp.clear();
                for (i = 0; i < wc.fNamespaceList.length; ++i) {
                    if (this.wNSList.contains(wc.fNamespaceList[i])) continue;
                    this.wNSListTemp.add(wc.fNamespaceList[i]);
                }
                this.wNSList.clear();
                this.wNSList.addAll(this.wNSListTemp);
                return true;
            }
            this.wNSListTemp.clear();
            for (i = 0; i < wc.fNamespaceList.length; ++i) {
                if (!this.wNSList.contains(wc.fNamespaceList[i])) continue;
                this.wNSListTemp.add(wc.fNamespaceList[i]);
            }
            if (this.wNSList.size() == this.wNSListTemp.size()) {
                return changed;
            }
            this.wNSList.clear();
            this.wNSList.addAll(this.wNSListTemp);
            return true;
        }
        if (this.wType == 2) {
            for (i = 0; i < wc.fNamespaceList.length; ++i) {
                if (this.wNSList.contains(wc.fNamespaceList[i])) continue;
                this.wNSList.add(wc.fNamespaceList[i]);
                changed = true;
            }
        } else {
            for (i = 0; i < wc.fNamespaceList.length; ++i) {
                if (!this.wNSList.remove(wc.fNamespaceList[i])) continue;
                changed = true;
            }
        }
        return changed;
    }

    private boolean checkFinalStates() {
        for (int i = 0; i < this.states.size(); ++i) {
            StatePair sp = (StatePair)this.states.get(i);
            sp.getStates(this.b, this.d);
            if (!this.derived.endContentModel(this.d) || this.base.endContentModel(this.b)) continue;
            return false;
        }
        return true;
    }

    private Boolean checkAllDerived() {
        Boolean ret;
        if (this.base instanceof XSEmptyCM && (ret = this.checkAllEmpty()) != null) {
            return ret;
        }
        if (this.base instanceof XS11AllCM) {
            this.allb = (XS11AllCM)this.base;
            ret = this.checkAllAll();
            if (ret == null) {
                this.base = this.allb;
                this.derived = this.alld;
                this.cmb.testOccurrences(this.alld.calOccurs());
            }
            return ret;
        }
        this.dfab = (XSDFACM)this.base;
        ret = this.checkAllDFA();
        if (ret == null) {
            this.base = this.dfab;
            this.derived = this.alld;
            this.cmb.testOccurrences(this.alld.calOccurs());
        }
        return ret;
    }

    private Boolean checkAllEmpty() {
        int[] idx = new int[]{-1};
        if (this.base.nextWildcardTransition(this.b, this.bn, idx) != null) {
            this.base = new XS11AllCM(false, 0, null, ((XSEmptyCM)this.base).getOpenContent());
            return null;
        }
        return this.derived.nextElementTransition(this.d, this.dn, idx) == null && this.derived.nextWildcardTransition(this.d, this.dn, idx) == null;
    }

    private Boolean checkAllAll() {
        if (this.allb.getOpenContent() != null && this.allb.getOpenContent().fMode == 2 && this.alld.getOpenContent() != null && this.alld.getOpenContent().fMode == 1) {
            return null;
        }
        if (this.siblingsD == null) {
            this.getDerivedSiblings();
        }
        if (this.alld.hasOptionalContent()) {
            if (!this.checkOptionalContent()) {
                return Boolean.FALSE;
            }
        } else if (this.allb.hasOptionalContent()) {
            return null;
        }
        int[] matchD = this.derived.startContentModel();
        int[] usedB = this.base.startContentModel();
        this.indexd[0] = -1;
        while ((this.ed = this.derived.nextElementTransition(this.d, this.dn, this.indexd)) != null) {
            matchD[this.indexd[0]] = -1;
            this.matchedHead = false;
            if (!this.matchEE(matchD, usedB)) {
                return Boolean.FALSE;
            }
            if (this.matchedHead || this.ed.getScope() != 1) continue;
            XSElementDecl[] eds = this.sgh.getSubstitutionGroup(this.ed, (short)4);
            for (int i = 0; i < eds.length; ++i) {
                this.ed = eds[i];
                if (this.matchEE(matchD, usedB)) continue;
                return Boolean.FALSE;
            }
        }
        this.wDNList.clear();
        this.wDNList.addAll(this.siblingsD);
        this.indexd[0] = -1;
        while ((this.wd = this.derived.nextWildcardTransition(this.d, this.dn, this.indexd)) != null) {
            if (this.matchWE(usedB)) continue;
            return Boolean.FALSE;
        }
        int[] min = this.base.startContentModel();
        int[] max = this.base.startContentModel();
        this.indexd[0] = -1;
        while ((this.ed = this.derived.nextElementTransition(this.d, this.dn, this.indexd)) != null) {
            this.indexb[0] = matchD[this.indexd[0]];
            if (this.indexb[0] < 0) continue;
            this.alld.collectOccurs(min, max, this.indexb[0], this.indexd[0]);
        }
        this.allb = this.allb.copy();
        this.alld = this.alld.copy();
        if (!this.allb.removeAsBase(min, max, usedB)) {
            return Boolean.FALSE;
        }
        this.alld.removeAsDerived(max, usedB, matchD);
        return null;
    }

    private boolean checkOptionalContent() {
        int min;
        XSWildcardDecl wd1;
        int totalMin = this.allb.totalMin();
        if (!this.allb.hasOptionalContent() && totalMin != 0) {
            return false;
        }
        XSOpenContentDecl oc = this.alld.getOpenContent();
        XSWildcardDecl xSWildcardDecl = this.wd = oc == null ? null : oc.fWildcard;
        if (this.wd == null) {
            return true;
        }
        this.wDNList.clear();
        this.wDNList.addAll(this.siblingsD);
        this.copyDerivedWildcard();
        int[] idx = new int[]{-1};
        while (!this.emptyWildcard() && (wd1 = this.derived.nextWildcardTransition(this.d, this.dn, idx)) != null) {
            if (wd1 == this.wd) continue;
            this.subtractWildcard(wd1, true);
        }
        if (this.emptyWildcard()) {
            return true;
        }
        this.indexb[0] = -1;
        block1: while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            min = this.allb.min(this.indexb[0]);
            if (this.allowName(this.eb.fTargetNamespace, this.eb.fName)) {
                if (min <= 1 && min >= totalMin) continue;
                return false;
            }
            if (this.eb.getScope() != 1) continue;
            XSElementDecl[] ebs = this.sgh.getSubstitutionGroup(this.eb, (short)4);
            for (int j = 0; j < ebs.length; ++j) {
                this.eb = ebs[j];
                if (!this.allowName(this.eb.fTargetNamespace, this.eb.fName)) continue;
                if (min <= 1 && min >= totalMin) continue block1;
                return false;
            }
        }
        this.indexb[0] = -1;
        while ((this.wb = this.base.nextWildcardTransition(this.b, this.bn, this.indexb)) != null) {
            if (this.base.isOpenContent(this.wb) || !this.overlap() || (min = this.allb.min(this.indexb[0])) <= 1 && min >= totalMin) continue;
            return false;
        }
        return true;
    }

    private boolean overlap() {
        int i = 0;
        while (i < this.wANList.size()) {
            this.qname.uri = (String)this.wANList.get(i++);
            this.qname.localpart = (String)this.wANList.get(i++);
            if (!this.base.allowExpandedName(this.wb, this.qname, this.sgh, this)) continue;
            return true;
        }
        if (this.wType == 1 || this.wb.fType == 1 || this.wType == 2 && this.wb.fType == 2) {
            return true;
        }
        if (this.wType == 3 && this.wb.fType == 3) {
            for (i = 0; i < this.wb.fNamespaceList.length; ++i) {
                if (!this.wNSList.contains(this.wb.fNamespaceList[i])) continue;
                return true;
            }
            return false;
        }
        if (this.wType == 2) {
            for (i = 0; i < this.wb.fNamespaceList.length; ++i) {
                if (this.wNSList.contains(this.wb.fNamespaceList[i])) continue;
                return true;
            }
            return false;
        }
        for (i = 0; i < this.wNSList.size(); ++i) {
            int j;
            String ns = (String)this.wNSList.get(i);
            for (j = 0; !(j >= this.wb.fNamespaceList.length || ns == null && this.wb.fNamespaceList[j] == null || ns != null && ns.equals(this.wb.fNamespaceList[j])); ++j) {
            }
            if (j != this.wb.fNamespaceList.length) continue;
            return true;
        }
        return false;
    }

    private boolean matchEE(int[] matchD, int[] usedB) {
        int id = this.indexd[0];
        this.indexb[0] = -1;
        while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            int ib = this.indexb[0];
            if (this.eb.getName() == this.ed.getName() && this.eb.getNamespace() == this.ed.getNamespace()) {
                if (matchD[id] != -1 && matchD[id] != ib) {
                    usedB[matchD[id]] = -1;
                    usedB[ib] = -1;
                    return true;
                }
                if (usedB[ib] < 0) {
                    matchD[id] = ib;
                    return true;
                }
                if (matchD[id] == -1) {
                    matchD[id] = ib;
                    int n = ib;
                    usedB[n] = usedB[n] + 1;
                }
                this.matchedHead = this.eb == this.ed;
                return this.checkEERestriction();
            }
            XSElementDecl[] ebs = this.sgh.getSubstitutionGroup(this.eb, (short)4);
            for (int i = 0; i < ebs.length; ++i) {
                if (ebs[i].getName() != this.ed.getName() || ebs[i].getNamespace() != this.ed.getNamespace()) continue;
                if (matchD[id] != -1 && matchD[id] != ib) {
                    if (matchD[id] >= 0) {
                        usedB[matchD[id]] = -1;
                    }
                    usedB[ib] = -1;
                    return true;
                }
                if (usedB[ib] < 0) {
                    matchD[id] = ib;
                    return true;
                }
                if (matchD[id] == -1) {
                    matchD[id] = ib;
                    int n = ib;
                    usedB[n] = usedB[n] + 1;
                }
                this.eb = ebs[i];
                return this.checkEERestriction();
            }
        }
        if (matchD[id] >= 0) {
            usedB[matchD[id]] = -1;
        }
        matchD[id] = -2;
        return true;
    }

    private boolean matchWE(int[] usedB) {
        this.indexb[0] = -1;
        while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            int ib = this.indexb[0];
            if (usedB[ib] <= 0) continue;
            Boolean res = this.checkWERestriction();
            if (res != null) {
                if (!res.booleanValue()) {
                    return false;
                }
                usedB[ib] = -1;
                return true;
            }
            if (this.eb.getScope() != 1) continue;
            XSElementDecl[] ebs = this.sgh.getSubstitutionGroup(this.eb, (short)4);
            for (int i = 0; i < ebs.length; ++i) {
                this.eb = ebs[i];
                res = this.checkWERestriction();
                if (res == null) continue;
                if (!res.booleanValue()) {
                    return false;
                }
                usedB[ib] = -1;
                return true;
            }
        }
        return true;
    }

    private Boolean checkAllDFA() {
        return null;
    }

    private static class StatePair {
        private final int[] states;

        public StatePair(int[] b, int[] d) {
            this.states = new int[b.length + d.length];
            System.arraycopy(b, 0, this.states, 0, b.length);
            System.arraycopy(d, 0, this.states, this.states.length - d.length, d.length);
        }

        private void set(int[] b, int[] d) {
            System.arraycopy(b, 0, this.states, 0, b.length);
            System.arraycopy(d, 0, this.states, this.states.length - d.length, d.length);
        }

        private void getStates(int[] b, int[] d) {
            System.arraycopy(this.states, 0, b, 0, b.length);
            System.arraycopy(this.states, this.states.length - d.length, d, 0, d.length);
        }

        public int hashCode() {
            int res = 0;
            for (int i = 0; i < this.states.length; ++i) {
                res = res * 7 + this.states[i];
            }
            return res;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StatePair)) {
                return false;
            }
            StatePair sp = (StatePair)o;
            return Arrays.equals(this.states, sp.states);
        }
    }

    static interface XS11CM
    extends XSCMValidator {
        public XSElementDecl nextElementTransition(int[] var1, int[] var2, int[] var3);

        public XSWildcardDecl nextWildcardTransition(int[] var1, int[] var2, int[] var3);

        public boolean isOpenContent(XSWildcardDecl var1);

        public boolean allowExpandedName(XSWildcardDecl var1, QName var2, SubstitutionGroupHandler var3, XSElementDeclHelper var4);

        public List getDefinedNames(SubstitutionGroupHandler var1);

        public void optimizeStates(XS11CM var1, int[] var2, int[] var3, int var4);
    }
}

