/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.context.notification.OptimisedNotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHelper {
    private static final Logger logger = LoggerFactory.getLogger(NotificationHelper.class);
    private final Class<? extends Notification> notificationClass;
    private final boolean dynamicNotifications;
    private final ServerNotificationHandler defaultNotificationHandler;
    private final LoadingCache<MuleContext, ServerNotificationHandler> serverNotificationHandlers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<MuleContext, ServerNotificationHandler>(){

        public ServerNotificationHandler load(MuleContext muleContext) throws Exception {
            return NotificationHelper.this.adaptNotificationHandler(muleContext.getNotificationManager());
        }
    });

    public NotificationHelper(ServerNotificationHandler defaultNotificationHandler, Class<? extends Notification> notificationClass, boolean dynamicNotifications) {
        this.notificationClass = notificationClass;
        this.dynamicNotifications = dynamicNotifications;
        this.defaultNotificationHandler = this.adaptNotificationHandler(defaultNotificationHandler);
    }

    public boolean isNotificationEnabled() {
        return this.defaultNotificationHandler.isNotificationEnabled(this.notificationClass);
    }

    public boolean isNotificationEnabled(MuleContext muleContext) {
        return this.getNotificationHandler(muleContext).isNotificationEnabled(this.notificationClass);
    }

    public void fireNotification(Component source, CoreEvent event, FlowConstruct flowConstruct, int action) {
        this.fireNotification(source, event, flowConstruct.getLocation(), flowConstruct.getMuleContext(), action);
    }

    public void fireNotification(Component source, CoreEvent event, ComponentLocation location, MuleContext context, int action) {
        ServerNotificationHandler serverNotificationHandler = this.getNotificationHandler(context);
        try {
            if (serverNotificationHandler.isNotificationEnabled(this.notificationClass)) {
                serverNotificationHandler.fireNotification((Notification)new ConnectorMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, (Component)source), location, action));
            }
        }
        catch (Exception e) {
            logger.warn("Could not fire notification. Action: " + action, (Throwable)e);
        }
    }

    public void fireNotification(Notification notification) {
        this.defaultNotificationHandler.fireNotification(notification);
    }

    public void fireNotification(Notification notification, MuleContext muleContext) {
        this.getNotificationHandler(muleContext).fireNotification(notification);
    }

    private ServerNotificationHandler adaptNotificationHandler(ServerNotificationHandler serverNotificationHandler) {
        return this.dynamicNotifications ? serverNotificationHandler : new OptimisedNotificationHandler(serverNotificationHandler, this.notificationClass);
    }

    private ServerNotificationHandler getNotificationHandler(MuleContext muleContext) {
        return (ServerNotificationHandler)this.serverNotificationHandlers.getUnchecked((Object)muleContext);
    }
}

