/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.policy;

import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PolicyNextActionMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    @Inject
    private PolicyStateHandler policyStateHandler;
    @Inject
    private MuleContext muleContext;
    private PolicyNotificationHelper notificationHelper;

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Mono.from(publisher).flatMapMany(event -> {
            Processor nextOperation = this.policyStateHandler.retrieveNextOperation(event.getContext().getCorrelationId());
            if (nextOperation == null) {
                return Mono.error((Throwable)new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("There's no next operation configured for event context id " + event.getContext().getId()))));
            }
            return Mono.just((Object)event).doOnNext(this.notificationHelper.notification(2102)).transform((Function)nextOperation).doOnSuccess(this.notificationHelper.notification(2103)).doOnError(MessagingException.class, this.notificationHelper.errorNotification(2103));
        });
    }

    public void initialise() throws InitialisationException {
        this.notificationHelper = new PolicyNotificationHelper(this.muleContext.getNotificationManager(), this.muleContext.getConfiguration().getId(), (Component)this);
    }
}

