/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.exception.RollbackSourceCallback;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.exception.AbstractExceptionListener;

public abstract class AbstractSystemExceptionStrategy
extends AbstractExceptionListener
implements SystemExceptionHandler {
    protected Scheduler retryScheduler;

    @Override
    public void handleException(Exception ex, RollbackSourceCallback rollbackMethod) {
        this.fireNotification(ex, PrivilegedEvent.getCurrentEvent());
        this.doLogException(ex);
        this.logger.debug("Rolling back transaction");
        this.rollback(ex, rollbackMethod);
        DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload(ex);
        if (PrivilegedEvent.getCurrentEvent() != null) {
            PrivilegedEvent currentEvent = PrivilegedEvent.getCurrentEvent();
            currentEvent = PrivilegedEvent.builder(currentEvent).message(InternalMessage.builder(currentEvent.getMessage()).exceptionPayload(exceptionPayload).build()).build();
            PrivilegedEvent.setCurrentEvent(currentEvent);
        }
        if (ex instanceof ConnectException) {
            ((ConnectException)((Object)ex)).handleReconnection((Executor)this.retryScheduler);
        }
    }

    private void rollback(Exception ex, RollbackSourceCallback rollbackMethod) {
        this.rollback(ex);
        if (rollbackMethod != null) {
            rollbackMethod.rollback();
        }
    }

    @Override
    public void handleException(Exception ex) {
        this.handleException(ex, null);
    }

    @Override
    protected void doInitialise(MuleContext context) throws InitialisationException {
        this.retryScheduler = this.muleContext.getSchedulerService().ioScheduler(this.muleContext.getSchedulerBaseConfig().withShutdownTimeout(0L, TimeUnit.MILLISECONDS));
        super.doInitialise(context);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.retryScheduler != null) {
            this.retryScheduler.stop();
            this.retryScheduler = null;
        }
    }
}

