/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.policy.PolicyEventConverter;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SourcePolicyProcessor
implements Processor {
    private final Policy policy;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();
    private final Processor nextProcessor;

    public SourcePolicyProcessor(Policy policy, PolicyStateHandler policyStateHandler, Processor nextProcessor) {
        this.policy = policy;
        this.policyStateHandler = policyStateHandler;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public CoreEvent process(CoreEvent sourceEvent) throws MuleException {
        return MessageProcessors.processToApply(sourceEvent, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Mono.from(publisher).cast(PrivilegedEvent.class).flatMap(sourceEvent -> {
            String executionIdentifier = sourceEvent.getContext().getCorrelationId();
            this.policyStateHandler.updateNextOperation(executionIdentifier, this.buildSourceExecutionWithPolicyFunction(executionIdentifier, (PrivilegedEvent)sourceEvent));
            return Mono.just((Object)sourceEvent).map(event -> this.policyEventConverter.createEvent((PrivilegedEvent)sourceEvent, PrivilegedEvent.builder(sourceEvent.getContext()).message(Message.of(null)).build())).cast(CoreEvent.class).transform((Function)this.policy.getPolicyChain()).cast(PrivilegedEvent.class).map(event -> this.policyEventConverter.createEvent((PrivilegedEvent)event, (PrivilegedEvent)sourceEvent));
        });
    }

    private Processor buildSourceExecutionWithPolicyFunction(final String executionIdentifier, final PrivilegedEvent sourceEvent) {
        return new Processor(){

            @Override
            public CoreEvent process(CoreEvent event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                return Mono.from(publisher).cast(PrivilegedEvent.class).flatMap(event -> Mono.just((Object)event).doOnNext(request -> SourcePolicyProcessor.this.policyStateHandler.updateState(new PolicyStateId(executionIdentifier, SourcePolicyProcessor.this.policy.getPolicyId()), (CoreEvent)request)).map(request -> SourcePolicyProcessor.this.policyEventConverter.createEvent((PrivilegedEvent)request, sourceEvent)).cast(CoreEvent.class).transform((Function)SourcePolicyProcessor.this.nextProcessor).cast(PrivilegedEvent.class).map(result -> SourcePolicyProcessor.this.policyEventConverter.createEvent((PrivilegedEvent)result, (PrivilegedEvent)event)));
            }
        };
    }
}

