/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class WorkQueueStreamProcessingStrategyFactory
extends AbstractStreamProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new WorkQueueStreamProcessingStrategy(() -> muleContext.getSchedulerService().customScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + RING_BUFFER_SCHEDULER_NAME_SUFFIX).withMaxConcurrentTasks(this.getSubscriberCount() + 1).withWaitAllowed(true)), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), this.getMaxConcurrency());
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return WorkQueueStreamProcessingStrategy.class;
    }

    static class WorkQueueStreamProcessingStrategy
    extends AbstractStreamProcessingStrategyFactory.AbstractStreamProcessingStrategy
    implements Startable,
    Stoppable {
        private final Supplier<Scheduler> blockingSchedulerSupplier;
        private Scheduler blockingScheduler;

        protected WorkQueueStreamProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscribers, String waitStrategy, Supplier<Scheduler> blockingSchedulerSupplier, int maxConcurrency) {
            super(ringBufferSchedulerSupplier, bufferSize, subscribers, waitStrategy, maxConcurrency);
            this.blockingSchedulerSupplier = Objects.requireNonNull(blockingSchedulerSupplier);
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            if (this.maxConcurrency > this.subscribers) {
                return publisher -> Flux.from((Publisher)publisher).flatMap(event -> Flux.just((Object)event).transform((Function)pipeline).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.blockingScheduler))), this.maxConcurrency);
            }
            return super.onPipeline(pipeline);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
                return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.blockingScheduler)));
            }
            return super.onProcessor(processor);
        }

        public void start() throws MuleException {
            this.blockingScheduler = this.blockingSchedulerSupplier.get();
        }

        public void stop() throws MuleException {
            if (this.blockingScheduler != null) {
                this.blockingScheduler.stop();
            }
        }
    }
}

