/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.exception.ErrorMapping;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.policy.FlowExecutionException;
import org.mule.runtime.core.internal.util.InternalExceptionUtils;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;

public class MessagingExceptionResolver {
    private final Component component;

    public MessagingExceptionResolver(Component component) {
        this.component = component;
    }

    public MessagingException resolve(MessagingException me, MuleContext context) {
        MessagingException result;
        ErrorTypeLocator locator = ((PrivilegedMuleContext)context).getErrorTypeLocator();
        Optional<Pair<Throwable, ErrorType>> rootCause = this.findRoot(this.component, me, locator);
        if (!rootCause.isPresent()) {
            return this.updateCurrent(me, this.component, context);
        }
        Throwable root = (Throwable)rootCause.get().getFirst();
        ErrorType rootErrorType = (ErrorType)rootCause.get().getSecond();
        Component failingComponent = this.getFailingProcessor(me, root).orElse(this.component);
        ErrorType errorType = InternalExceptionUtils.getErrorMappings(this.component).stream().filter(m -> m.match(rootErrorType)).findFirst().map(ErrorMapping::getTarget).orElse(rootErrorType);
        Error error = ErrorBuilder.builder(ExceptionUtils.getMessagingExceptionCause(root)).errorType(errorType).build();
        CoreEvent event = CoreEvent.builder(me.getEvent()).error(error).build();
        if (root instanceof MessagingException) {
            ((MessagingException)((Object)root)).setProcessedEvent(event);
            result = (MessagingException)((Object)root);
        } else {
            result = me instanceof FlowExecutionException ? new FlowExecutionException(event, root, failingComponent) : new MessagingException(event, root, failingComponent);
        }
        return this.enrich(result, failingComponent, event, context);
    }

    private Optional<Pair<Throwable, ErrorType>> findRoot(Component obj, MessagingException me, ErrorTypeLocator locator) {
        List<Pair<Throwable, ErrorType>> errors = this.collectErrors(obj, me, locator);
        if (errors.isEmpty()) {
            return this.collectCritical(obj, me, locator).stream().findFirst();
        }
        SingleErrorTypeMatcher matcher = new SingleErrorTypeMatcher((ErrorType)errors.get(0).getSecond());
        Reference result = new Reference();
        errors.forEach(p -> {
            if (matcher.match((ErrorType)p.getSecond())) {
                result.set(p);
            }
        });
        return Optional.ofNullable(result.get());
    }

    private List<Pair<Throwable, ErrorType>> collectErrors(Component obj, MessagingException me, ErrorTypeLocator locator) {
        LinkedList<Pair<Throwable, ErrorType>> errors = new LinkedList<Pair<Throwable, ErrorType>>();
        ExceptionHelper.getExceptionsAsList((Throwable)((Object)me)).forEach(e -> {
            ErrorType type = this.errorTypeFromException(obj, locator, (Throwable)e);
            if (!ExceptionUtils.isUnknownMuleError(type) && !this.isCriticalMuleError(type)) {
                errors.add(new Pair(e, (Object)type));
            }
        });
        return errors;
    }

    private List<Pair<Throwable, ErrorType>> collectCritical(Component obj, MessagingException me, ErrorTypeLocator locator) {
        LinkedList<Pair<Throwable, ErrorType>> errors = new LinkedList<Pair<Throwable, ErrorType>>();
        ExceptionHelper.getExceptionsAsList((Throwable)((Object)me)).forEach(e -> {
            ErrorType type = this.errorTypeFromException(obj, locator, (Throwable)e);
            if (this.isCriticalMuleError(type)) {
                errors.add(new Pair(e, (Object)type));
            }
        });
        return errors;
    }

    private MessagingException updateCurrent(MessagingException me, Component processor, MuleContext context) {
        CoreEvent errorEvent = InternalExceptionUtils.createErrorEvent(me.getEvent(), processor, me, ((PrivilegedMuleContext)context).getErrorTypeLocator());
        Component failingProcessor = me.getFailingComponent() != null ? me.getFailingComponent() : processor;
        MessagingException updated = me instanceof FlowExecutionException ? new FlowExecutionException(errorEvent, me.getCause(), failingProcessor) : new MessagingException(me.getI18nMessage(), errorEvent, me.getCause(), failingProcessor);
        return this.enrich(updated, failingProcessor, errorEvent, context);
    }

    private Optional<Component> getFailingProcessor(MessagingException me, Throwable root) {
        Component failing = me.getFailingComponent();
        if (failing == null && root instanceof MessagingException) {
            failing = ((MessagingException)((Object)root)).getFailingComponent();
        }
        return Optional.ofNullable(failing);
    }

    private ErrorType errorTypeFromException(Component failing, ErrorTypeLocator locator, Throwable e) {
        if (this.isMessagingExceptionWithError(e)) {
            return ((MessagingException)((Object)e)).getEvent().getError().map(Error::getErrorType).orElse(locator.lookupErrorType(e));
        }
        Optional<ComponentIdentifier> componentIdentifier = ExceptionUtils.getComponentIdentifier(failing);
        return componentIdentifier.map(ci -> locator.lookupComponentErrorType((ComponentIdentifier)ci, e)).orElse(locator.lookupErrorType(e));
    }

    private boolean isMessagingExceptionWithError(Throwable cause) {
        return cause instanceof MessagingException && ((MessagingException)((Object)cause)).getEvent().getError().isPresent();
    }

    private MessagingException enrich(MessagingException me, Component failing, CoreEvent event, MuleContext context) {
        EnrichedNotificationInfo notificationInfo = EnrichedNotificationInfo.createInfo((Event)event, (Exception)((Object)me), null);
        context.getExceptionContextProviders().forEach(cp -> cp.getContextInfo(notificationInfo, failing).forEach((k, v) -> me.getInfo().putIfAbsent(k, v)));
        return me;
    }

    private boolean isCriticalMuleError(ErrorType type) {
        return type.getNamespace().equals(Errors.CORE_NAMESPACE_NAME) && type.getIdentifier().equals("CRITICAL");
    }
}

