/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.ProcessorInterceptorManager;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.component.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractMessageProcessorChain
extends AbstractExecutableComponent
implements MessageProcessorChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageProcessorChain.class);
    private final String name;
    private final List<Processor> processors;
    private ProcessingStrategy processingStrategy;
    private List<ReactiveInterceptorAdapter> additionalInterceptors = new LinkedList<ReactiveInterceptorAdapter>();
    @Inject
    private ProcessorInterceptorManager processorInterceptorManager;
    @Inject
    private StreamingManager streamingManager;

    AbstractMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors) {
        this.name = name;
        this.processingStrategy = processingStrategyOptional.orElse(null);
        this.processors = processors;
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptors = this.resolveInterceptors();
        Flux stream = Flux.from(publisher);
        for (Processor processor : this.getProcessorsToExecute()) {
            stream = stream.transform((Function)this.applyInterceptors(interceptors, processor));
        }
        return stream;
    }

    private ReactiveProcessor applyInterceptors(List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptorsToBeExecuted, Processor processor) {
        ReactiveProcessor interceptorWrapperProcessorFunction = processor;
        for (BiFunction<Processor, ReactiveProcessor, ReactiveProcessor> interceptor : interceptorsToBeExecuted) {
            interceptorWrapperProcessorFunction = interceptor.apply(processor, interceptorWrapperProcessorFunction);
        }
        return interceptorWrapperProcessorFunction;
    }

    private List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> resolveInterceptors() {
        ArrayList<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptors = new ArrayList<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>>();
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).onErrorMap(MessagingException.class, this.resolveMessagingException((Processor)processor)));
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).cast(PrivilegedEvent.class).doOnNext(event -> DefaultMuleContext.currentMuleContext.set(this.muleContext)).doOnNext(event -> PrivilegedEvent.setCurrentEvent(event)).cast(CoreEvent.class).transform((Function)next));
        if (this.processingStrategy != null) {
            interceptors.add((processor, next) -> this.processingStrategy.onProcessor(new ReactiveProcessor((ReactiveProcessor)next, (Processor)processor){
                final /* synthetic */ ReactiveProcessor val$next;
                final /* synthetic */ Processor val$processor;
                {
                    this.val$next = reactiveProcessor;
                    this.val$processor = processor;
                }

                @Override
                public Publisher<CoreEvent> apply(Publisher<CoreEvent> eventPublisher) {
                    return (Publisher)this.val$next.apply(eventPublisher);
                }

                @Override
                public ReactiveProcessor.ProcessingType getProcessingType() {
                    return this.val$processor.getProcessingType();
                }
            }));
        }
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).cast(PrivilegedEvent.class).doOnNext(result -> PrivilegedEvent.setCurrentEvent(result)).cast(CoreEvent.class));
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).cast(PrivilegedEvent.class).doOnNext(this.preNotification((Processor)processor)).cast(CoreEvent.class).transform((Function)next).cast(PrivilegedEvent.class).doOnNext(this.postNotification((Processor)processor)).doOnError(MessagingException.class, this.errorNotification((Processor)processor)).cast(CoreEvent.class));
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).map(StreamingUtils.updateEventForStreaming(this.streamingManager)));
        interceptors.addAll(0, this.additionalInterceptors);
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).concatMap(event -> Flux.just((Object)event).transform((Function)next).doOnEach(signal -> DefaultMuleContext.currentMuleContext.set(null)).onErrorResume(RejectedExecutionException.class, throwable -> Mono.from(((BaseEventContext)event.getContext()).error((Throwable)((Object)this.resolveException((Component)processor, (CoreEvent)event, (Throwable)throwable)))).then(Mono.empty())).onErrorResume(MessagingException.class, throwable -> {
            throwable = this.resolveMessagingException((Processor)processor).apply((MessagingException)((Object)((Object)((Object)((Object)throwable)))));
            return Mono.from(((BaseEventContext)event.getContext()).error((Throwable)((Object)throwable))).then(Mono.empty());
        })));
        return interceptors;
    }

    private MessagingException resolveException(Component processor, CoreEvent event, Throwable throwable) {
        MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(processor);
        return exceptionResolver.resolve(new MessagingException(event, throwable, processor), this.muleContext);
    }

    private Function<MessagingException, MessagingException> resolveMessagingException(Processor processor) {
        if (processor instanceof Component) {
            MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver((Component)processor);
            return exception -> exceptionResolver.resolve((MessagingException)((Object)exception), this.muleContext);
        }
        return exception -> exception;
    }

    private Consumer<PrivilegedEvent> preNotification(Processor processor) {
        return event -> {
            if (event.isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), (CoreEvent)event, processor, null, 1601);
            }
        };
    }

    private Consumer<PrivilegedEvent> postNotification(Processor processor) {
        return event -> {
            if (event.isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), (CoreEvent)event, processor, null, 1602);
            }
        };
    }

    private Consumer<Exception> errorNotification(Processor processor) {
        return exception -> {
            if (exception instanceof MessagingException && ((PrivilegedEvent)((MessagingException)((Object)((Object)exception))).getEvent()).isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), ((MessagingException)((Object)((Object)exception))).getEvent(), processor, (MessagingException)((Object)((Object)exception)), 1602);
            }
        };
    }

    private void fireNotification(ServerNotificationManager serverNotificationManager, CoreEvent event, Processor processor, MessagingException exceptionThrown, int action) {
        if (serverNotificationManager != null && serverNotificationManager.isNotificationEnabled(MessageProcessorNotification.class) && ((Component)processor).getLocation() != null) {
            serverNotificationManager.fireNotification((Notification)MessageProcessorNotification.createFrom((Event)event, (ComponentLocation)((Component)processor).getLocation(), (Component)((Component)processor), (Exception)((Object)exceptionThrown), (int)action));
        }
    }

    protected List<Processor> getProcessorsToExecute() {
        return this.processors;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.getClass().getSimpleName());
        if (!org.mule.runtime.core.api.util.StringUtils.isBlank(this.name)) {
            string.append(String.format(" '%s' ", this.name));
        }
        Iterator<Processor> mpIterator = this.processors.iterator();
        String nl = String.format("%n", new Object[0]);
        if (mpIterator.hasNext()) {
            string.append(String.format("%n[ ", new Object[0]));
            while (mpIterator.hasNext()) {
                Processor mp = mpIterator.next();
                String indented = StringUtils.replace((String)mp.toString(), (String)nl, (String)String.format("%n  ", new Object[0]));
                string.append(String.format("%n  %s", indented));
                if (!mpIterator.hasNext()) continue;
                string.append(", ");
            }
            string.append(String.format("%n]", new Object[0]));
        }
        return string.toString();
    }

    @Override
    public List<Processor> getMessageProcessors() {
        return this.processors;
    }

    protected List<Processor> getMessageProcessorsForLifecycle() {
        return this.processors;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        LifecycleUtils.setMuleContextIfNeeded(this.getMessageProcessorsForLifecycle(), muleContext);
    }

    public void initialise() throws InitialisationException {
        this.processorInterceptorManager.getInterceptorFactories().stream().forEach(interceptorFactory -> {
            ReactiveInterceptorAdapter reactiveInterceptorAdapter = new ReactiveInterceptorAdapter((ProcessorInterceptorFactory)interceptorFactory);
            try {
                this.muleContext.getInjector().inject(reactiveInterceptorAdapter);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            this.additionalInterceptors.add(0, reactiveInterceptorAdapter);
        });
        LifecycleUtils.initialiseIfNeeded(this.getMessageProcessorsForLifecycle(), this.muleContext);
    }

    public void start() throws MuleException {
        ArrayList<Processor> startedProcessors = new ArrayList<Processor>();
        try {
            for (Processor processor : this.getMessageProcessorsForLifecycle()) {
                if (!(processor instanceof Startable)) continue;
                ((Startable)processor).start();
                startedProcessors.add(processor);
            }
        }
        catch (MuleException e) {
            LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
            throw e;
        }
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.getMessageProcessorsForLifecycle(), LOGGER);
    }
}

