/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxExtensionsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u0087\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0018\n\u0002\u0010\u0005\n\u0002\u0010\u0012\n\u0002\u0010\u0006\n\u0002\u0010\u0013\n\u0002\u0010\u0007\n\u0002\u0010\u0014\n\u0002\u0010\b\n\u0002\u0010\u0015\n\u0002\u0010\t\n\u0002\u0010\u0016\n\u0002\u0010\n\n\u0002\u0010\u0017\n\u0002\u0010\u001c\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003*\u0001+\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u0006\u0012\u0002\b\u00030\u0001H\u0086\b\u001aH\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000b0\n\u001a#\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u0006\u0012\u0002\b\u00030\u0001H\u0086\b\u001aH\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\n\u001aR\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00110\n\u001aE\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\u0013\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0016\u001a#\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00190\u0001*\u00020\u001a\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0001*\u00020\u001c\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0001*\u00020\u001e\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0001*\u00020 \u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020!0\u0001*\u00020\"\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020#0\u0001*\u00020$\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020%0\u0001*\u00020&\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u00020\u0006\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020'\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020(\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020)\u001a#\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u00020+\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020(H\u0002\u00a2\u0006\u0002\u0010,\u00a8\u0006-"}, d2={"cast", "Lreactor/core/publisher/Flux;", "T", "", "doOnError", "E", "", "exceptionType", "Lkotlin/reflect/KClass;", "onError", "Lkotlin/Function1;", "", "ofType", "onErrorMap", "mapper", "onErrorResume", "fallback", "Lorg/reactivestreams/Publisher;", "onErrorReturn", "value", "(Lreactor/core/publisher/Flux;Lkotlin/reflect/KClass;Ljava/lang/Object;)Lreactor/core/publisher/Flux;", "toFlux", "Ljava/util/stream/Stream;", "", "([Ljava/lang/Object;)Lreactor/core/publisher/Flux;", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "Lkotlin/sequences/Sequence;", "toIterable", "reactor/core/publisher/FluxExtensionsKt$toIterable$1", "(Ljava/util/Iterator;)Lreactor/core/publisher/FluxExtensionsKt$toIterable$1;", "reactor-core_main"})
public final class FluxExtensionsKt {
    @NotNull
    public static final <T> Flux<T> toFlux(@NotNull Iterator<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return FluxExtensionsKt.toFlux(FluxExtensionsKt.toIterable($receiver));
    }

    @NotNull
    public static final <T> Flux<T> toFlux(@NotNull Iterable<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Flux<? extends T> flux = Flux.fromIterable($receiver);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"Flux.fromIterable(this)");
        return flux;
    }

    @NotNull
    public static final <T> Flux<T> toFlux(@NotNull Sequence<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Flux flux = Flux.fromIterable(new Iterable<T>($receiver){
            final /* synthetic */ Sequence receiver$0;

            @NotNull
            public Iterator<T> iterator() {
                return this.receiver$0.iterator();
            }
            {
                this.receiver$0 = $receiver;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"Flux.fromIterable(object\u2026this@toFlux.iterator()\n})");
        return flux;
    }

    @NotNull
    public static final <T> Flux<T> toFlux(@NotNull Stream<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Flux<T> flux = Flux.fromStream($receiver);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"Flux.fromStream(this)");
        return flux;
    }

    @NotNull
    public static final Flux<Boolean> toFlux(@NotNull boolean[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FluxExtensionsKt.toFlux(ArraysKt.toList((boolean[])$receiver));
    }

    @NotNull
    public static final Flux<Byte> toFlux(@NotNull byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FluxExtensionsKt.toFlux(ArraysKt.toList((byte[])$receiver));
    }

    @NotNull
    public static final Flux<Short> toFlux(@NotNull short[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FluxExtensionsKt.toFlux(ArraysKt.toList((short[])$receiver));
    }

    @NotNull
    public static final Flux<Integer> toFlux(@NotNull int[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FluxExtensionsKt.toFlux(ArraysKt.toList((int[])$receiver));
    }

    @NotNull
    public static final Flux<Long> toFlux(@NotNull long[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FluxExtensionsKt.toFlux(ArraysKt.toList((long[])$receiver));
    }

    @NotNull
    public static final Flux<Float> toFlux(@NotNull float[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FluxExtensionsKt.toFlux(ArraysKt.toList((float[])$receiver));
    }

    @NotNull
    public static final Flux<Double> toFlux(@NotNull double[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FluxExtensionsKt.toFlux(ArraysKt.toList((double[])$receiver));
    }

    @NotNull
    public static final <T> Flux<T> toFlux(@NotNull T[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Flux<T> flux = Flux.fromArray($receiver);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"Flux.fromArray(this)");
        return flux;
    }

    private static final <T> toIterable.1 toIterable(@NotNull Iterator<? extends T> $receiver) {
        return new Iterable<T>($receiver){
            final /* synthetic */ Iterator receiver$0;

            @NotNull
            public Iterator<T> iterator() {
                return this.receiver$0;
            }
            {
                this.receiver$0 = $receiver;
            }
        };
    }

    @NotNull
    public static final <T> Flux<T> toFlux(@NotNull Throwable $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Flux flux = Flux.error($receiver);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"Flux.error(this)");
        return flux;
    }

    private static final <T> Flux<T> cast(@NotNull Flux<?> $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Flux<Object> flux = $receiver.cast(Object.class);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"cast(T::class.java)");
        return flux;
    }

    @NotNull
    public static final <T, E extends Throwable> Flux<T> doOnError(@NotNull Flux<T> $receiver, @NotNull KClass<E> exceptionType, @NotNull Function1<? super E, Unit> onError) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(exceptionType, (String)"exceptionType");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        Flux<T> flux = $receiver.doOnError(JvmClassMappingKt.getJavaClass(exceptionType), new Consumer<E>(onError){
            final /* synthetic */ Function1 $onError;

            public final void accept(E it) {
                E e = it;
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"it");
                this.$onError.invoke(e);
            }
            {
                this.$onError = function1;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"doOnError(exceptionType.java, { onError(it) })");
        return flux;
    }

    @NotNull
    public static final <T, E extends Throwable> Flux<T> onErrorMap(@NotNull Flux<T> $receiver, @NotNull KClass<E> exceptionType, @NotNull Function1<? super E, ? extends Throwable> mapper) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(exceptionType, (String)"exceptionType");
        Intrinsics.checkParameterIsNotNull(mapper, (String)"mapper");
        Flux<T> flux = $receiver.onErrorMap(JvmClassMappingKt.getJavaClass(exceptionType), new Function<E, Throwable>(mapper){
            final /* synthetic */ Function1 $mapper;

            @NotNull
            public final Throwable apply(E it) {
                E e = it;
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"it");
                return (Throwable)this.$mapper.invoke(e);
            }
            {
                this.$mapper = function1;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"onErrorMap(exceptionType.java, { mapper(it) })");
        return flux;
    }

    private static final <T> Flux<T> ofType(@NotNull Flux<?> $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Flux<Object> flux = $receiver.ofType(Object.class);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"ofType(T::class.java)");
        return flux;
    }

    @NotNull
    public static final <T, E extends Throwable> Flux<T> onErrorResume(@NotNull Flux<T> $receiver, @NotNull KClass<E> exceptionType, @NotNull Function1<? super E, ? extends Publisher<T>> fallback) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(exceptionType, (String)"exceptionType");
        Intrinsics.checkParameterIsNotNull(fallback, (String)"fallback");
        Flux<T> flux = $receiver.onErrorResume(JvmClassMappingKt.getJavaClass(exceptionType), new Function<E, Publisher<? extends T>>(fallback){
            final /* synthetic */ Function1 $fallback;

            @NotNull
            public final Publisher<T> apply(E it) {
                E e = it;
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"it");
                return (Publisher)this.$fallback.invoke(e);
            }
            {
                this.$fallback = function1;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"onErrorResume(exceptionT\u2026e.java, { fallback(it) })");
        return flux;
    }

    @NotNull
    public static final <T, E extends Throwable> Flux<T> onErrorReturn(@NotNull Flux<T> $receiver, @NotNull KClass<E> exceptionType, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(exceptionType, (String)"exceptionType");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Flux<T> flux = $receiver.onErrorReturn(JvmClassMappingKt.getJavaClass(exceptionType), value);
        Intrinsics.checkExpressionValueIsNotNull(flux, (String)"onErrorReturn(exceptionType.java, value)");
        return flux;
    }
}

