/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import com.google.common.base.Preconditions;
import java.util.Optional;

public class BundleDescriptor {
    private static final String STRINGARTIFACT_FILENAME_SEPARATOR = "-";
    private String groupId;
    private String artifactId;
    private String version;
    private String type = "jar";
    private Optional<String> classifier = Optional.empty();
    private String artifactFileName;

    private BundleDescriptor() {
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getClassifier() {
        return this.classifier;
    }

    public boolean isPlugin() {
        return this.classifier.map(classifier -> classifier.equals("mule-plugin")).orElse(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleDescriptor that = (BundleDescriptor)o;
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return "BundleDescriptor{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", type='" + this.type + '\'' + ", classifier=" + this.classifier + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArtifactFileName() {
        if (this.artifactFileName == null) {
            BundleDescriptor bundleDescriptor = this;
            synchronized (bundleDescriptor) {
                if (this.artifactFileName == null) {
                    String fileName = this.artifactId;
                    if (this.getVersion() != null) {
                        fileName = fileName + STRINGARTIFACT_FILENAME_SEPARATOR + this.getVersion();
                    }
                    if (this.classifier.isPresent()) {
                        fileName = fileName + STRINGARTIFACT_FILENAME_SEPARATOR + this.classifier.get();
                    }
                    this.artifactFileName = fileName;
                }
            }
        }
        return this.artifactFileName;
    }

    public static class Builder {
        private static final String ARTIFACT_ID = "artifact id";
        private static final String VERSION = "version";
        private static final String GROUP_ID = "group id";
        private static final String TYPE = "type";
        private static final String CLASSIFIER = "classifier";
        private static final String REQUIRED_FIELD_NOT_FOUND_TEMPLATE = "bundle cannot be created with null or empty %s";
        private BundleDescriptor bundleDependency = new BundleDescriptor();

        public Builder setGroupId(String groupId) {
            this.validateIsNotEmpty(groupId, GROUP_ID);
            this.bundleDependency.groupId = groupId;
            return this;
        }

        public Builder setArtifactId(String artifactId) {
            this.validateIsNotEmpty(artifactId, ARTIFACT_ID);
            this.bundleDependency.artifactId = artifactId;
            return this;
        }

        public Builder setVersion(String version) {
            this.validateIsNotEmpty(version, VERSION);
            this.bundleDependency.version = version;
            return this;
        }

        public Builder setType(String type) {
            this.validateIsNotEmpty(type, TYPE);
            this.bundleDependency.type = type;
            return this;
        }

        public Builder setClassifier(String classifier) {
            this.bundleDependency.classifier = Optional.ofNullable(classifier);
            return this;
        }

        public BundleDescriptor build() {
            this.validateIsNotEmpty(this.bundleDependency.groupId, GROUP_ID);
            this.validateIsNotEmpty(this.bundleDependency.artifactId, ARTIFACT_ID);
            this.validateIsNotEmpty(this.bundleDependency.version, VERSION);
            return this.bundleDependency;
        }

        private String getNullFieldMessage(String field) {
            return String.format(REQUIRED_FIELD_NOT_FOUND_TEMPLATE, field);
        }

        private void validateIsNotEmpty(String value, String fieldId) {
            Preconditions.checkState((!Builder.isEmpty(value) ? 1 : 0) != 0, (Object)this.getNullFieldMessage(fieldId));
        }

        private static boolean isEmpty(String value) {
            return value == null || value.equals("");
        }
    }
}

