/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.util.function.Function;
import reactor.retry.BackoffDelay;
import reactor.retry.Context;

public interface Backoff
extends Function<Context<?>, BackoffDelay> {
    public static final Backoff ZERO_BACKOFF = context -> BackoffDelay.ZERO;

    public static Backoff zero() {
        return ZERO_BACKOFF;
    }

    public static Backoff fixed(Duration backoffInterval) {
        return context -> new BackoffDelay(backoffInterval);
    }

    public static Backoff exponential(Duration firstBackoff, Duration maxBackoff, int factor, boolean basedOnPreviousValue) {
        Duration maxBackoffInterval;
        if (firstBackoff == null || firstBackoff.isNegative() || firstBackoff.isZero()) {
            throw new IllegalArgumentException("firstBackoff must be > 0");
        }
        Duration duration = maxBackoffInterval = maxBackoff != null ? maxBackoff : Duration.ofSeconds(Long.MAX_VALUE);
        if (maxBackoffInterval.compareTo(firstBackoff) <= 0) {
            throw new IllegalArgumentException("maxBackoff must be >= firstBackoff");
        }
        if (!basedOnPreviousValue) {
            return context -> {
                Duration nextBackoff = firstBackoff.multipliedBy((long)Math.pow(factor, context.iteration() - 1L));
                return new BackoffDelay(firstBackoff, maxBackoffInterval, nextBackoff);
            };
        }
        return context -> {
            Duration prevBackoff = context.backoff() == null ? Duration.ZERO : context.backoff();
            Duration nextBackoff = prevBackoff.multipliedBy(factor);
            nextBackoff = nextBackoff.compareTo(firstBackoff) < 0 ? firstBackoff : nextBackoff;
            return new BackoffDelay(firstBackoff, maxBackoff, nextBackoff);
        };
    }
}

