/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.Scannable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxPublish;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.QueueSupplier;

public final class EmitterProcessor<T>
extends FluxProcessor<T, T>
implements Receiver {
    final int maxConcurrency;
    final int prefetch;
    final boolean autoCancel;
    volatile Subscription s;
    static final AtomicReferenceFieldUpdater<EmitterProcessor, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(EmitterProcessor.class, Subscription.class, "s");
    volatile FluxPublish.PubSubInner<T>[] subscribers;
    static final AtomicReferenceFieldUpdater<EmitterProcessor, FluxPublish.PubSubInner[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(EmitterProcessor.class, FluxPublish.PubSubInner[].class, "subscribers");
    volatile int wip;
    static final AtomicIntegerFieldUpdater<EmitterProcessor> WIP = AtomicIntegerFieldUpdater.newUpdater(EmitterProcessor.class, "wip");
    volatile Queue<T> queue;
    int sourceMode;
    volatile boolean done;
    volatile Throwable error;
    static final AtomicReferenceFieldUpdater<EmitterProcessor, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(EmitterProcessor.class, Throwable.class, "error");

    public static <E> EmitterProcessor<E> create() {
        return EmitterProcessor.create(true);
    }

    public static <E> EmitterProcessor<E> create(boolean autoCancel) {
        return EmitterProcessor.create(QueueSupplier.SMALL_BUFFER_SIZE, autoCancel);
    }

    public static <E> EmitterProcessor<E> create(int bufferSize) {
        return EmitterProcessor.create(bufferSize, Integer.MAX_VALUE);
    }

    @Deprecated
    public static <E> EmitterProcessor<E> create(int bufferSize, int concurrency) {
        return EmitterProcessor.create(bufferSize, concurrency, true);
    }

    public static <E> EmitterProcessor<E> create(int bufferSize, boolean autoCancel) {
        return EmitterProcessor.create(bufferSize, Integer.MAX_VALUE, autoCancel);
    }

    @Deprecated
    public static <E> EmitterProcessor<E> create(int bufferSize, int concurrency, boolean autoCancel) {
        return new EmitterProcessor(autoCancel, concurrency, bufferSize);
    }

    EmitterProcessor(boolean autoCancel, int maxConcurrency, int prefetch) {
        if (prefetch < 1) {
            throw new IllegalArgumentException("bufferSize must be strictly positive, was: " + prefetch);
        }
        this.autoCancel = autoCancel;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
        SUBSCRIBERS.lazySet(this, FluxPublish.PublishSubscriber.EMPTY);
    }

    @Deprecated
    public Subscription upstream() {
        return this.s;
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return Stream.of(this.subscribers);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s == null) {
            throw Exceptions.argumentIsNullException();
        }
        EmitterInner<T> inner = new EmitterInner<T>(s, this);
        s.onSubscribe(inner);
        if (inner.isCancelled()) {
            return;
        }
        if (this.add(inner)) {
            if (inner.isCancelled()) {
                this.remove(inner);
            }
            this.drain();
        } else {
            Throwable e = this.error;
            if (e != null) {
                inner.actual.onError(e);
            } else {
                inner.actual.onComplete();
            }
        }
    }

    @Deprecated
    public EmitterProcessor<T> connect() {
        this.onSubscribe(Operators.emptySubscription());
        return this;
    }

    @Override
    public long getPending() {
        Queue<T> q = this.queue;
        return q != null ? (long)q.size() : 0L;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.setOnce(S, this, s)) {
            if (s instanceof Fuseable.QueueSubscription) {
                Fuseable.QueueSubscription f = (Fuseable.QueueSubscription)s;
                int m = f.requestFusion(3);
                if (m == 1) {
                    this.sourceMode = m;
                    this.queue = f;
                    this.done = true;
                    this.drain();
                    return;
                }
                if (m == 2) {
                    this.sourceMode = m;
                    this.queue = f;
                    s.request((long)this.prefetch);
                    return;
                }
            }
            this.queue = QueueSupplier.get(this.prefetch).get();
            s.request((long)this.prefetch);
        }
    }

    public void onNext(T t) {
        if (t == null && this.sourceMode == 0) {
            throw Exceptions.argumentIsNullException();
        }
        if (this.done) {
            return;
        }
        if (this.sourceMode == 2) {
            this.drain();
            return;
        }
        Queue<T> q = this.queue;
        if (q == null) {
            if (Operators.setOnce(S, this, Operators.emptySubscription())) {
                q = QueueSupplier.get(this.prefetch).get();
                this.queue = q;
            } else {
                do {
                    if (!this.isDisposed()) continue;
                    return;
                } while ((q = this.queue) == null);
            }
        }
        while (!q.offer(t)) {
            LockSupport.parkNanos(10L);
        }
        this.drain();
    }

    public void onError(Throwable t) {
        if (t == null) {
            throw Exceptions.argumentIsNullException();
        }
        if (this.done) {
            Operators.onErrorDropped(t);
            return;
        }
        if (Exceptions.addThrowable(ERROR, this, t)) {
            this.done = true;
            this.drain();
        } else {
            Operators.onErrorDropped(t);
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean isCancelled() {
        return Operators.cancelledSubscription() == this.s;
    }

    @Override
    public final int getBufferSize() {
        return this.prefetch;
    }

    @Override
    @Deprecated
    public boolean isStarted() {
        return this.s != null;
    }

    @Override
    public boolean isTerminated() {
        return this.done && this.getPending() == 0L;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.s;
            }
            case BUFFERED: {
                return (int)this.getPending();
            }
            case CANCELLED: {
                return this.isCancelled();
            }
        }
        return super.scan(key);
    }

    final void drain() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int missed = 1;
        while (true) {
            boolean empty;
            boolean d = this.done;
            Queue<T> q = this.queue;
            boolean bl = empty = q == null || q.isEmpty();
            if (this.checkTerminated(d, empty)) {
                return;
            }
            if (!empty) {
                FluxPublish.PubSubInner<T>[] a = this.subscribers;
                long maxRequested = Long.MAX_VALUE;
                int len = a.length;
                int cancel = 0;
                for (FluxPublish.PubSubInner<T> inner : a) {
                    long r = inner.requested;
                    if (r >= 0L) {
                        maxRequested = Math.min(maxRequested, r);
                        continue;
                    }
                    ++cancel;
                }
                if (len == cancel) {
                    T v;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this.s, ex));
                        d = true;
                        v = null;
                    }
                    if (this.checkTerminated(d, v == null)) {
                        return;
                    }
                    if (this.sourceMode == 1) continue;
                    this.s.request(1L);
                    continue;
                }
                int e = 0;
                while ((long)e < maxRequested && cancel != Integer.MIN_VALUE) {
                    T v;
                    d = this.done;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this.s, ex));
                        d = true;
                        v = null;
                    }
                    boolean bl2 = empty = v == null;
                    if (this.checkTerminated(d, empty)) {
                        return;
                    }
                    if (empty) break;
                    for (FluxPublish.PubSubInner<T> inner : a) {
                        inner.actual.onNext(v);
                        if (FluxPublish.PubSubInner.produced(inner, 1L) != Long.MIN_VALUE) continue;
                        cancel = Integer.MIN_VALUE;
                    }
                    ++e;
                }
                if (e != 0 && this.sourceMode != 1) {
                    this.s.request((long)e);
                }
                if (maxRequested != 0L && !empty) continue;
            }
            if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
        }
    }

    FluxPublish.PubSubInner<T>[] terminate() {
        return SUBSCRIBERS.getAndSet(this, FluxPublish.PublishSubscriber.TERMINATED);
    }

    boolean checkTerminated(boolean d, boolean empty) {
        if (this.s == Operators.cancelledSubscription()) {
            if (this.autoCancel) {
                this.terminate();
                Queue<T> q = this.queue;
                if (q != null) {
                    q.clear();
                }
            }
            return true;
        }
        if (d) {
            Throwable e = this.error;
            if (e != null && e != Exceptions.TERMINATED) {
                Queue<T> q = this.queue;
                if (q != null) {
                    q.clear();
                }
                for (FluxPublish.PubSubInner<T> inner : this.terminate()) {
                    inner.actual.onError(e);
                }
                return true;
            }
            if (empty) {
                for (FluxPublish.PubSubInner<T> inner : this.terminate()) {
                    inner.actual.onComplete();
                }
                return true;
            }
        }
        return false;
    }

    final boolean add(EmitterInner<T> inner) {
        FluxPublish.PubSubInner[] b;
        FluxPublish.PubSubInner<T>[] a;
        do {
            if ((a = this.subscribers) == FluxPublish.PublishSubscriber.TERMINATED) {
                return false;
            }
            int n = a.length;
            if (n + 1 > this.maxConcurrency) {
                throw new IllegalStateException("Cannot subscribe more than " + this.maxConcurrency + " subscribers.");
            }
            b = new FluxPublish.PubSubInner[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        return true;
    }

    final void remove(FluxPublish.PubSubInner<T> inner) {
        FluxPublish.PubSubInner[] b;
        FluxPublish.PubSubInner<T>[] a = this.subscribers;
        if (a == FluxPublish.PublishSubscriber.TERMINATED || a == FluxPublish.PublishSubscriber.EMPTY) {
            return;
        }
        int n = a.length;
        int j = -1;
        for (int i = 0; i < n; ++i) {
            if (a[i] != inner) continue;
            j = i;
            break;
        }
        if (j < 0) {
            return;
        }
        if (n == 1) {
            b = FluxPublish.PublishSubscriber.EMPTY;
        } else {
            b = new FluxPublish.PubSubInner[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        }
        if (SUBSCRIBERS.compareAndSet(this, a, b) && this.autoCancel && b == FluxPublish.PublishSubscriber.EMPTY && Operators.terminate(S, this)) {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            this.terminate();
            Queue<T> q = this.queue;
            if (q != null) {
                q.clear();
            }
        }
    }

    @Override
    public long downstreamCount() {
        return this.subscribers.length;
    }

    static final class EmitterInner<T>
    extends FluxPublish.PubSubInner<T> {
        final EmitterProcessor<T> parent;

        EmitterInner(Subscriber<? super T> actual, EmitterProcessor<T> parent) {
            super(actual);
            this.parent = parent;
        }

        @Override
        void drainParent() {
            this.parent.drain();
        }

        @Override
        void removeAndDrainParent() {
            this.parent.remove(this);
            this.parent.drain();
        }
    }
}

