/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class FluxCancelOn<T>
extends FluxSource<T, T> {
    final Scheduler scheduler;

    public FluxCancelOn(Flux<T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new CancelSubscriber<T>(s, this.scheduler));
    }

    static final class CancelSubscriber<T>
    implements InnerOperator<T, T>,
    Runnable {
        final Subscriber<? super T> actual;
        final Scheduler scheduler;
        Subscription s;
        volatile int cancelled = 0;
        static final AtomicIntegerFieldUpdater<CancelSubscriber> CANCELLED = AtomicIntegerFieldUpdater.newUpdater(CancelSubscriber.class, "cancelled");

        CancelSubscriber(Subscriber<? super T> actual, Scheduler scheduler) {
            this.actual = actual;
            this.scheduler = scheduler;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.cancelled == 1;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void run() {
            this.s.cancel();
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            if (CANCELLED.compareAndSet(this, 0, 1) && this.scheduler.schedule(this) == Scheduler.REJECTED) {
                throw Operators.onRejectedExecution();
            }
        }
    }
}

