/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.api.dsl.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.core.api.processor.Router;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public abstract class ComponentModel {
    private boolean root = false;
    private ComponentIdentifier identifier;
    private Map<String, Object> customAttributes = new HashMap<String, Object>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private Set<String> schemaValueParameter = new HashSet<String>();
    private ComponentModel parent;
    private List<ComponentModel> innerComponents = new ArrayList<ComponentModel>();
    private String textContent;
    private DefaultComponentLocation componentLocation;
    private Object objectInstance;
    private Class<?> type;
    private Integer lineNumber;
    private String configFileName;
    private boolean enabled = true;

    public Optional<Integer> getLineNumber() {
        return Optional.ofNullable(this.lineNumber);
    }

    public Optional<String> getConfigFileName() {
        return Optional.ofNullable(this.configFileName);
    }

    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public List<ComponentModel> getInnerComponents() {
        return this.innerComponents;
    }

    public Map<String, Object> getCustomAttributes() {
        return ImmutableMap.copyOf(this.customAttributes);
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setParameter(String parameterName, String value) {
        this.parameters.put(parameterName, value);
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getNameAttribute() {
        return this.parameters.get("name");
    }

    public boolean isScope() {
        return Router.class.isAssignableFrom(this.type);
    }

    public void setParent(ComponentModel parent) {
        this.parent = parent;
    }

    public ComponentModel getParent() {
        return this.parent;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setComponentLocation(DefaultComponentLocation componentLocation) {
        this.componentLocation = componentLocation;
    }

    public DefaultComponentLocation getComponentLocation() {
        return this.componentLocation;
    }

    public Object getObjectInstance() {
        return this.objectInstance;
    }

    public void setObjectInstance(Object objectInstance) {
        this.objectInstance = objectInstance;
    }

    public boolean isParameterValueProvidedBySchema(String parameterName) {
        return this.schemaValueParameter.contains(parameterName);
    }

    public ComponentConfiguration getConfiguration() {
        ComponentConfiguration.Builder builder = ComponentConfiguration.builder().withIdentifier(this.getIdentifier()).withValue(this.textContent);
        this.parameters.entrySet().forEach(e -> builder.withParameter((String)e.getKey(), (String)e.getValue()));
        this.innerComponents.forEach(i -> builder.withNestedComponent(i.getConfiguration()));
        this.customAttributes.forEach((arg_0, arg_1) -> ((ComponentConfiguration.Builder)builder).withProperty(arg_0, arg_1));
        return builder.build();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void executedOnEveryInnerComponent(Consumer<ComponentModel> task) {
        for (ComponentModel componentModel : this.innerComponents) {
            task.accept(componentModel);
            componentModel.executedOnEveryInnerComponent(task);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentModel that = (ComponentModel)o;
        if (this.root != that.root) {
            return false;
        }
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.innerComponents.equals(that.innerComponents);
    }

    public int hashCode() {
        int result = this.root ? 1 : 0;
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.innerComponents.hashCode();
        return result;
    }

    public static class Builder {
        private ComponentModel model = new SpringComponentModel();
        private ComponentModel root;

        public Builder() {
        }

        public Builder(ComponentModel root) {
            this.root = root;
        }

        public Builder setIdentifier(ComponentIdentifier identifier) {
            this.checkIsNotBuildingFromRootComponentModel("identifier");
            this.model.identifier = identifier;
            return this;
        }

        public Builder addParameter(String parameterName, String value, boolean valueFromSchema) {
            this.checkIsNotBuildingFromRootComponentModel("parameters");
            this.model.parameters.put(parameterName, value);
            if (valueFromSchema) {
                this.model.schemaValueParameter.add(parameterName);
            }
            return this;
        }

        public Builder addChildComponentModel(ComponentModel componentModel) {
            this.checkIsNotBuildingFromRootComponentModel("innerComponents");
            this.model.innerComponents.add(componentModel);
            componentModel.setParent(this.model);
            return this;
        }

        public Builder setTextContent(String textContent) {
            this.checkIsNotBuildingFromRootComponentModel("textComponent");
            this.model.textContent = textContent;
            return this;
        }

        public Builder markAsRootComponent() {
            this.checkIsNotBuildingFromRootComponentModel("root");
            this.model.root = true;
            return this;
        }

        public Builder addCustomAttribute(String name, Object value) {
            this.checkIsNotBuildingFromRootComponentModel("customAttributes");
            this.model.customAttributes.put(name, value);
            return this;
        }

        public Builder setConfigFileName(String configFileName) {
            this.checkIsNotBuildingFromRootComponentModel("configFileName");
            this.model.configFileName = configFileName;
            return this;
        }

        public Builder setLineNumber(int lineNumber) {
            this.checkIsNotBuildingFromRootComponentModel("lineNumber");
            this.model.lineNumber = lineNumber;
            return this;
        }

        public Builder merge(ComponentModel otherRootComponentModel) {
            this.root.customAttributes.putAll(otherRootComponentModel.customAttributes);
            this.root.parameters.putAll(otherRootComponentModel.parameters);
            this.root.schemaValueParameter.addAll(otherRootComponentModel.schemaValueParameter);
            this.root.innerComponents.addAll(otherRootComponentModel.innerComponents);
            return this;
        }

        public ComponentModel build() {
            if (this.root != null) {
                return this.root;
            }
            Preconditions.checkState((this.model.identifier != null ? 1 : 0) != 0, (String)"An identifier must be provided");
            return this.model;
        }

        private void checkIsNotBuildingFromRootComponentModel(String parameter) {
            Preconditions.checkState((this.root == null ? 1 : 0) != 0, (String)String.format("%s cannot be modified when builder has been constructed from a root component", parameter));
        }
    }
}

