/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model.util;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class ArtifactUtils {
    public static ArtifactCoordinates toArtifactCoordinates(BundleDescriptor bundleDescriptor) {
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), bundleDescriptor.getBaseVersion(), bundleDescriptor.getType(), bundleDescriptor.getClassifier().orElse(null));
        return artifactCoordinates;
    }

    public static Artifact toArtifact(BundleDependency bundleDependency) {
        ArtifactCoordinates artifactCoordinates = ArtifactUtils.toArtifactCoordinates(bundleDependency.getDescriptor());
        return new Artifact(artifactCoordinates, bundleDependency.getBundleUri());
    }

    public static List<Artifact> toArtifacts(Collection<BundleDependency> dependencies) {
        return dependencies.stream().map(ArtifactUtils::toArtifact).collect(Collectors.toList());
    }

    public static boolean isValidMulePlugin(Artifact artifact) {
        ArtifactCoordinates pluginCoordinates = artifact.getArtifactCoordinates();
        Optional<String> pluginClassifier = Optional.ofNullable(pluginCoordinates.getClassifier());
        return pluginClassifier.isPresent() && "mule-plugin".equals(pluginClassifier.get());
    }

    public static boolean isValidMulePlugin(org.apache.maven.artifact.Artifact artifact) {
        Optional<String> pluginClassifier = Optional.ofNullable(artifact.getClassifier());
        return pluginClassifier.isPresent() && "mule-plugin".equals(pluginClassifier.get());
    }

    public static org.apache.maven.artifact.Artifact toArtifact(Artifact dependencyArtifact) {
        ArtifactCoordinates artifactCoordinates = dependencyArtifact.getArtifactCoordinates();
        DefaultArtifact artifact = new DefaultArtifact(artifactCoordinates.getGroupId(), artifactCoordinates.getArtifactId(), artifactCoordinates.getVersion(), null, artifactCoordinates.getType(), artifactCoordinates.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler(artifactCoordinates.getType()));
        artifact.setFile(new File(dependencyArtifact.getUri()));
        return artifact;
    }

    public static ArtifactCoordinates toArtifactCoordinates(org.apache.maven.artifact.Artifact artifact) {
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
        artifactCoordinates.setType(artifact.getType());
        artifactCoordinates.setClassifier(artifact.getClassifier());
        return artifactCoordinates;
    }

    public static Dependency toDependency(ArtifactCoordinates artifactCoordinates) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifactCoordinates.getGroupId());
        dependency.setArtifactId(artifactCoordinates.getArtifactId());
        dependency.setVersion(artifactCoordinates.getVersion());
        dependency.setType(artifactCoordinates.getType());
        dependency.setClassifier(artifactCoordinates.getClassifier());
        dependency.setScope(artifactCoordinates.getScope());
        return dependency;
    }

    public static ArtifactCoordinates toArtifactCoordinates(Dependency dependency) {
        return new ArtifactCoordinates(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier(), dependency.getScope());
    }
}

