/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.metadata.TypedValue;

public class DefaultExpressionModuleBuilder
implements ExpressionModule.Builder {
    private Map<String, TypedValue<?>> bindings;
    private ModuleNamespace namespace;

    public DefaultExpressionModuleBuilder(ModuleNamespace namespace) {
        this.namespace = namespace;
        this.bindings = new HashMap();
    }

    public ExpressionModule.Builder addBinding(String identifier, TypedValue<?> typedValue) {
        this.bindings.put(identifier, typedValue);
        return this;
    }

    public ExpressionModule build() {
        return new DefaultExpressionModule(this.bindings, this.namespace);
    }

    private static class DefaultExpressionModule
    implements ExpressionModule {
        private Map<String, TypedValue<?>> bindings;
        private ModuleNamespace namespace;

        public DefaultExpressionModule(Map<String, TypedValue<?>> bindings, ModuleNamespace namespace) {
            this.bindings = bindings;
            this.namespace = namespace;
        }

        public Collection<Binding> bindings() {
            return this.bindings.entrySet().stream().map(entry -> new Binding((String)entry.getKey(), (TypedValue)entry.getValue())).collect(Collectors.toList());
        }

        public Collection<String> identifiers() {
            return this.bindings.keySet();
        }

        public Optional<TypedValue> lookup(String identifier) {
            return Optional.ofNullable(this.bindings.get(identifier));
        }

        public ModuleNamespace namespace() {
            return this.namespace;
        }
    }
}

