/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategyFactory;
import reactor.core.Disposable;
import reactor.core.publisher.BlockingSink;
import reactor.core.publisher.WorkQueueProcessor;
import reactor.util.concurrent.QueueSupplier;
import reactor.util.concurrent.WaitStrategy;

abstract class AbstractStreamProcessingStrategyFactory
extends AbstractProcessingStrategyFactory {
    private static final String SYSTEM_PROPERTY_PREFIX = AbstractStreamProcessingStrategyFactory.class.getName() + ".";
    public static final int DEFAULT_BUFFER_SIZE = Integer.getInteger(SYSTEM_PROPERTY_PREFIX + "DEFAULT_BUFFER_SIZE", QueueSupplier.SMALL_BUFFER_SIZE);
    public static final int DEFAULT_SUBSCRIBER_COUNT = Integer.getInteger(SYSTEM_PROPERTY_PREFIX + "DEFAULT_SUBSCRIBER_COUNT", 1);
    public static final String DEFAULT_WAIT_STRATEGY = System.getProperty(SYSTEM_PROPERTY_PREFIX + "DEFAULT_WAIT_STRATEGY", AbstractStreamProcessingStrategy.WaitStrategy.LITE_BLOCKING.name());
    protected static String RING_BUFFER_SCHEDULER_NAME_SUFFIX = ".ring-buffer";
    private int bufferSize = DEFAULT_BUFFER_SIZE;
    private int subscriberCount = DEFAULT_SUBSCRIBER_COUNT;
    private String waitStrategy = DEFAULT_WAIT_STRATEGY;

    AbstractStreamProcessingStrategyFactory() {
    }

    public void setBufferSize(int bufferSize) {
        if (!QueueSupplier.isPowerOfTwo((int)bufferSize)) {
            throw new IllegalArgumentException("bufferSize must be a power of 2 : " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    public void setSubscriberCount(int subscriberCount) {
        this.subscriberCount = subscriberCount;
    }

    public void setWaitStrategy(String waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected int getSubscriberCount() {
        return this.subscriberCount;
    }

    protected String getWaitStrategy() {
        return this.waitStrategy;
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return AbstractStreamProcessingStrategy.class;
    }

    static abstract class AbstractStreamProcessingStrategy
    extends AbstractProcessingStrategy {
        protected final Supplier<Scheduler> ringBufferSchedulerSupplier;
        protected final int bufferSize;
        protected final int subscribers;
        protected final WaitStrategy waitStrategy;
        protected final int maxConcurrency;

        protected AbstractStreamProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscribers, String waitStrategy, int maxConcurrency) {
            this.subscribers = Objects.requireNonNull(subscribers);
            this.waitStrategy = WaitStrategy.valueOf(waitStrategy);
            this.bufferSize = Objects.requireNonNull(bufferSize);
            this.ringBufferSchedulerSupplier = Objects.requireNonNull(ringBufferSchedulerSupplier);
            this.maxConcurrency = Objects.requireNonNull(maxConcurrency);
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor function) {
            WorkQueueProcessor processor = WorkQueueProcessor.share((ExecutorService)((ExecutorService)this.ringBufferSchedulerSupplier.get()), (int)this.bufferSize, (reactor.util.concurrent.WaitStrategy)this.waitStrategy.getReactorWaitStrategy(), (boolean)false);
            ArrayList<Disposable> disposables = new ArrayList<Disposable>();
            for (int i = 0; i < (this.maxConcurrency < this.subscribers ? this.maxConcurrency : this.subscribers); ++i) {
                disposables.add(processor.transform((Function)function).subscribe());
            }
            disposables.add(() -> processor.shutdown());
            return new AbstractProcessingStrategy.ReactorSink((BlockingSink<InternalEvent>)processor.connectSink(), () -> disposables.forEach(disposable -> disposable.dispose()), this.createOnEventConsumer());
        }

        protected static enum WaitStrategy {
            BLOCKING(reactor.util.concurrent.WaitStrategy.blocking()),
            LITE_BLOCKING(reactor.util.concurrent.WaitStrategy.liteBlocking()),
            SLEEPING(reactor.util.concurrent.WaitStrategy.sleeping()),
            BUSY_SPIN(reactor.util.concurrent.WaitStrategy.busySpin()),
            YIELDING(reactor.util.concurrent.WaitStrategy.yielding()),
            PARKING(reactor.util.concurrent.WaitStrategy.parking()),
            PHASED(reactor.util.concurrent.WaitStrategy.phasedOffLiteLock((long)200L, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS));

            private reactor.util.concurrent.WaitStrategy reactorWaitStrategy;

            private WaitStrategy(reactor.util.concurrent.WaitStrategy reactorWaitStrategy) {
                this.reactorWaitStrategy = reactorWaitStrategy;
            }

            reactor.util.concurrent.WaitStrategy getReactorWaitStrategy() {
                return this.reactorWaitStrategy;
            }
        }
    }
}

