/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultTransformationService;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.connector.DispatchException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.internal.routing.RoutingFailedException;
import org.mule.runtime.core.internal.routing.RoutingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstSuccessfulRoutingStrategy
implements RoutingStrategy {
    @Inject
    private DefaultTransformationService transformationService;
    protected static transient Logger logger = LoggerFactory.getLogger(FirstSuccessfulRoutingStrategy.class);
    private final RouteProcessor processor;

    public FirstSuccessfulRoutingStrategy(RouteProcessor processor) {
        this.processor = processor;
    }

    public static void validateMessageIsNotConsumable(Message message) {
        if (message.getPayload().getDataType().isStreamType()) {
            throw new MuleRuntimeException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getDataType().getType().getName()));
        }
    }

    @Override
    public InternalEvent route(InternalEvent event, List<Processor> messageProcessors) throws MuleException {
        InternalEvent returnEvent = null;
        boolean failed = true;
        Exception failExceptionCause = null;
        FirstSuccessfulRoutingStrategy.validateMessageIsNotConsumable(event.getMessage());
        for (Processor mp : messageProcessors) {
            try {
                returnEvent = this.processor.processRoute(mp, InternalEvent.builder(DefaultEventContext.child(event.getContext(), Optional.empty()), event).build());
                failed = returnEvent == null ? false : (returnEvent.getMessage() == null ? true : returnEvent.getError().isPresent());
            }
            catch (Exception ex) {
                failed = true;
                failExceptionCause = ex;
            }
            if (failed) continue;
            break;
        }
        if (failed) {
            if (failExceptionCause != null) {
                throw new RoutingFailedException(I18nMessageFactory.createStaticMessage((String)"All processors failed during 'first-successful' routing strategy"), failExceptionCause);
            }
            throw new RoutingFailedException(I18nMessageFactory.createStaticMessage((String)"All processors failed during 'first-successful' routing strategy"));
        }
        return returnEvent != null ? InternalEvent.builder(event.getContext(), returnEvent).build() : null;
    }

    protected final InternalEvent sendRequest(InternalEvent routedEvent, Message message, Processor route, boolean awaitResponse) throws MuleException {
        InternalEvent result;
        try {
            result = this.sendRequestEvent(routedEvent, message, route, awaitResponse);
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(null, e);
        }
        if (result != null) {
            Message resultMessage = result.getMessage();
            if (logger.isTraceEnabled() && resultMessage != null) {
                try {
                    logger.trace("Response payload: \n" + StringMessageUtils.truncate(this.transformationService.getPayloadForLogging(resultMessage), 100, false));
                }
                catch (Exception e) {
                    logger.trace("Response payload: \n(unable to retrieve payload: " + e.getMessage());
                }
            }
        }
        return result;
    }

    private InternalEvent sendRequestEvent(InternalEvent routedEvent, Message message, Processor route, boolean awaitResponse) throws MuleException {
        if (route == null) {
            throw new DispatchException(CoreMessages.objectIsNull("route"), null);
        }
        return route.process(routedEvent);
    }

    static interface RouteProcessor {
        public InternalEvent processRoute(Processor var1, InternalEvent var2) throws MuleException;
    }
}

