/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.Serializable;
import org.apache.commons.lang3.NotImplementedException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.queue.DefaultQueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueStoreDelegate;
import org.mule.runtime.core.internal.util.queue.DefaultQueueStoreDelegate;
import org.mule.runtime.core.internal.util.queue.DualRandomAccessFileQueueStoreDelegate;
import org.mule.runtime.core.internal.util.queue.RecoverableQueueStore;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueStoreDelegate;

public class DefaultQueueStore
implements RecoverableQueueStore {
    private QueueConfiguration config;
    private String name;
    private QueueStoreDelegate delegate;
    private MuleContext muleContext;

    public DefaultQueueStore(String name, MuleContext muleContext, QueueConfiguration config) {
        this.name = name;
        this.muleContext = muleContext;
        this.setConfigAndDelegate(config);
    }

    public void setConfig(QueueConfiguration config) {
        this.setConfigAndDelegate(config);
    }

    private void setConfigAndDelegate(QueueConfiguration newConfig) {
        if (this.delegate != null) {
            return;
        }
        this.config = newConfig;
        if (this.config == null) {
            this.config = new DefaultQueueConfiguration();
        }
        this.delegate = this.config.isPersistent() ? new DualRandomAccessFileQueueStoreDelegate(this.name, this.muleContext.getConfiguration().getWorkingDirectory(), this.muleContext, this.config.getCapacity()) : new DefaultQueueStoreDelegate(this.config.getCapacity());
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultQueueStore && this.name.equals(((DefaultQueueStore)obj).name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void putNow(Serializable o) {
        this.delegate.putNow(o);
    }

    @Override
    public boolean offer(Serializable o, int room, long timeout) throws InterruptedException {
        return this.delegate.offer(o, room, timeout);
    }

    @Override
    public Serializable poll(long timeout) throws InterruptedException {
        return this.delegate.poll(timeout);
    }

    @Override
    public Serializable peek() throws InterruptedException {
        return this.delegate.peek();
    }

    @Override
    public void untake(Serializable item) throws InterruptedException {
        this.delegate.untake(item);
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public void clear() throws InterruptedException {
        this.delegate.clear();
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    @Override
    public int getCapacity() {
        return this.config == null ? null : Integer.valueOf(this.config.getCapacity());
    }

    @Override
    public void remove(Serializable value) {
        if (!(this.delegate instanceof TransactionalQueueStoreDelegate)) {
            throw new NotImplementedException(String.format("Queue of type %s does not support remove", this.delegate.getClass().getCanonicalName()));
        }
        ((TransactionalQueueStoreDelegate)this.delegate).remove(value);
    }

    @Override
    public boolean contains(Serializable value) {
        if (this.delegate instanceof TransactionalQueueStoreDelegate) {
            return ((TransactionalQueueStoreDelegate)this.delegate).contains(value);
        }
        throw new NotImplementedException(String.format("Queue of type %s does not support contains", this.delegate.getClass().getCanonicalName()));
    }

    @Override
    public void close() {
        if (!(this.delegate instanceof TransactionalQueueStoreDelegate)) {
            throw new NotImplementedException(String.format("Queue of type %s does not support close", this.delegate.getClass().getCanonicalName()));
        }
        ((TransactionalQueueStoreDelegate)this.delegate).close();
    }

    @Override
    public boolean isPersistent() {
        return this.config.isPersistent();
    }
}

