/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import com.ibm.icu.lang.UCharacter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.StringCodePointIterator;

public class FnSubstring
extends Function {
    public FnSubstring() {
        super(new QName("substring"), 2, 3);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        return FnSubstring.substring(args);
    }

    public static ResultSequence substring(Collection<ResultSequence> args) throws DynamicError {
        Collection<ResultSequence> cargs = Function.convert_arguments(args, FnSubstring.expected_args(args));
        Iterator<ResultSequence> argi = cargs.iterator();
        ResultSequence stringArg = argi.next();
        ResultSequence startPosArg = argi.next();
        ResultSequence lengthArg = null;
        if (argi.hasNext()) {
            lengthArg = argi.next();
        }
        if (stringArg.empty()) {
            return FnSubstring.emptyString();
        }
        String str = ((XSString)stringArg.first()).value();
        double dstart = ((XSDouble)startPosArg.first()).double_value();
        if (Double.isNaN(dstart) || Double.NEGATIVE_INFINITY == dstart) {
            return FnSubstring.emptyString();
        }
        long istart = Math.round(dstart);
        long ilength = Long.MAX_VALUE;
        if (lengthArg != null) {
            double dlength = ((XSDouble)lengthArg.first()).double_value();
            if (Double.isNaN(dlength)) {
                return FnSubstring.emptyString();
            }
            ilength = Math.round(dlength);
            if (ilength <= 0L) {
                return FnSubstring.emptyString();
            }
        }
        StringBuffer sb = new StringBuffer((int)Math.min((long)str.length(), ilength));
        StringCodePointIterator strIter = new StringCodePointIterator(str);
        long p = 1L;
        while (strIter.current() != -1) {
            if (istart <= p && p - istart < ilength) {
                sb.append(UCharacter.toChars((int)strIter.current()));
            }
            ++p;
            strIter.next();
        }
        return new XSString(sb.toString());
    }

    private static ResultSequence emptyString() {
        return new XSString("");
    }

    public static Collection<SeqType> expected_args(Collection<ResultSequence> actualArgs) {
        ArrayList<SeqType> _expected_args = new ArrayList<SeqType>();
        _expected_args.add(new SeqType(new XSString(), 3));
        _expected_args.add(new SeqType(new XSDouble(), 0));
        if (actualArgs.size() == 3) {
            _expected_args.add(new SeqType(new XSDouble(), 0));
        }
        return _expected_args;
    }
}

