/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types.builtin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.internal.XPathError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.AtomicTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.SingleItemSequence;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class BuiltinTypeDefinition
implements AtomicTypeDefinition {
    public static final String XS_NS = "http://www.w3.org/2001/XMLSchema";
    private final QName name;
    private final Class<?> implementationClass;
    private final Class<?> nativeType;
    private final BuiltinTypeDefinition baseType;
    private final Method constructorMethod;
    private final Method constructorFromNativeMethod;

    public BuiltinTypeDefinition(QName name, BuiltinTypeDefinition baseType) {
        this(name, null, null, baseType);
    }

    public BuiltinTypeDefinition(String name, BuiltinTypeDefinition baseType) {
        this(name, null, null, baseType);
    }

    public BuiltinTypeDefinition(QName name, Class<? extends AnyType> implementationClass, Class<?> nativeType, BuiltinTypeDefinition baseType) {
        this.name = name;
        this.implementationClass = implementationClass;
        this.nativeType = nativeType;
        this.baseType = baseType;
        Method m = null;
        try {
            m = implementationClass != null ? implementationClass.getMethod("constructor", ResultSequence.class) : null;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        this.constructorMethod = m;
        m = null;
        try {
            m = implementationClass != null ? implementationClass.getMethod("constructor", nativeType) : null;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        this.constructorFromNativeMethod = m;
    }

    public boolean isAbstract() {
        return this.implementationClass == null;
    }

    public BuiltinTypeDefinition(String name, Class<? extends AnyType> implementationClass, Class<?> nativeType, BuiltinTypeDefinition baseType) {
        this(new QName(XS_NS, name), implementationClass, nativeType, baseType);
    }

    @Override
    public String getNamespace() {
        return this.name.getNamespaceURI();
    }

    @Override
    public String getName() {
        return this.name.getLocalPart();
    }

    @Override
    public TypeDefinition getBaseType() {
        return this.baseType;
    }

    @Override
    public boolean derivedFromType(TypeDefinition ancestorType, short derivationMethod) {
        if (ancestorType == this) {
            return true;
        }
        if (this.baseType == null) {
            return false;
        }
        return this.baseType.derivedFromType(ancestorType, derivationMethod);
    }

    @Override
    public boolean derivedFrom(String namespace, String name, short derivationMethod) {
        if (namespace.equals(this.getNamespace()) && name.equals(this.getName())) {
            return true;
        }
        if (this.baseType == null) {
            return false;
        }
        return this.baseType.derivedFrom(namespace, name, derivationMethod);
    }

    @Override
    public List<Short> getSimpleTypes(Attr attr) {
        return Collections.emptyList();
    }

    @Override
    public List<Short> getSimpleTypes(Element attr) {
        return Collections.emptyList();
    }

    @Override
    public SingleItemSequence construct(ResultSequence rs) {
        try {
            if (this.implementationClass == null) {
                throw new XPathError("Type " + this.getName() + " is abstract!");
            }
            return (SingleItemSequence)this.constructorMethod.invoke(null, rs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SingleItemSequence constructNative(Object obj) {
        try {
            if (this.constructorFromNativeMethod == null) {
                throw new XPathError("Type " + this.getName() + " cannot be constructed from native object!");
            }
            return (SingleItemSequence)this.constructorFromNativeMethod.invoke(null, obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<?> getNativeType() {
        return this.nativeType;
    }
}

