/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSOpenContentDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.models.XS11AllCM;
import org.apache.xerces.impl.xs.models.XSAllCM;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.models.XSDFACM;
import org.apache.xerces.impl.xs.models.XSEmptyCM;

public class CMBuilder {
    private XSDeclarationPool fDeclPool = null;
    private static final XSEmptyCM fEmptyCM = new XSEmptyCM();
    private int fLeafCount;
    private int fParticleCount;
    private final CMNodeFactory fNodeFactory;
    private short fSchemaVersion = 1;

    public CMBuilder(CMNodeFactory nodeFactory) {
        this.fNodeFactory = nodeFactory;
    }

    public void setDeclPool(XSDeclarationPool declPool) {
        this.fDeclPool = declPool;
    }

    public void setSchemaVersion(short version) {
        this.fSchemaVersion = version;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl typeDecl, boolean forUPA) {
        short contentType = typeDecl.getContentType();
        if (contentType == 1 || contentType == 0) {
            return null;
        }
        return this.getContentModel((XSParticleDecl)typeDecl.getParticle(), (XSOpenContentDecl)typeDecl.getOpenContent(), forUPA);
    }

    public XSCMValidator getContentModel(XSParticleDecl particle) {
        return this.getContentModel(particle, null, false);
    }

    private XSCMValidator getContentModel(XSParticleDecl particle, XSOpenContentDecl openContent, boolean forUPA) {
        if (particle == null) {
            return fEmptyCM;
        }
        XSCMValidator cmValidator = null;
        cmValidator = particle.fType == 3 && ((XSModelGroupImpl)particle.fValue).fCompositor == 103 ? (this.fSchemaVersion < 4 ? this.createAllCM(particle) : this.createAll11CM(particle, openContent)) : this.createDFACM(particle, forUPA, openContent);
        this.fNodeFactory.resetNodeCount();
        if (cmValidator == null) {
            cmValidator = openContent == null ? fEmptyCM : new XSEmptyCM(openContent);
        }
        return cmValidator;
    }

    XSCMValidator createAllCM(XSParticleDecl particle) {
        if (particle.fMaxOccurs == 0) {
            return null;
        }
        XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
        XSAllCM allContent = new XSAllCM(particle.fMinOccurs == 0, group.fParticleCount, this.fSchemaVersion);
        for (int i = 0; i < group.fParticleCount; ++i) {
            allContent.addElement((XSElementDecl)group.fParticles[i].fValue, group.fParticles[i].fMinOccurs == 0);
        }
        return allContent;
    }

    XSCMValidator createAll11CM(XSParticleDecl particle, XSOpenContentDecl openContent) {
        if (particle.fMaxOccurs == 0) {
            return null;
        }
        XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
        XS11AllCM allContent = new XS11AllCM(particle.fMinOccurs == 0, group.fParticleCount, group.fParticles, openContent);
        return allContent;
    }

    XSCMValidator createDFACM(XSParticleDecl particle, boolean forUPA, XSOpenContentDecl openContent) {
        CMNode node;
        this.fLeafCount = 0;
        this.fParticleCount = 0;
        CMNode cMNode = node = this.useRepeatingLeafNodes(particle) ? this.buildCompactSyntaxTree(particle) : this.buildSyntaxTree(particle, forUPA);
        if (node == null) {
            return null;
        }
        return new XSDFACM(node, this.fLeafCount, this.fSchemaVersion, openContent);
    }

    private CMNode buildSyntaxTree(XSParticleDecl particle, boolean forUPA) {
        int maxOccurs = particle.fMaxOccurs;
        int minOccurs = particle.fMinOccurs;
        boolean compactedForUPA = false;
        if (forUPA) {
            if (minOccurs > 1) {
                if (maxOccurs > minOccurs || particle.getMaxOccursUnbounded()) {
                    minOccurs = 1;
                    compactedForUPA = true;
                } else {
                    minOccurs = 2;
                    compactedForUPA = true;
                }
            }
            if (maxOccurs > 1) {
                maxOccurs = 2;
                compactedForUPA = true;
            }
        }
        short type = particle.fType;
        CMNode nodeRet = null;
        if (type == 2 || type == 1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            if ((nodeRet = this.expandContentModel(nodeRet, minOccurs, maxOccurs)) != null) {
                nodeRet.setIsCompactUPAModel(compactedForUPA);
            }
        } else if (type == 3) {
            XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
            CMNode temp = null;
            int count = 0;
            for (int i = 0; i < group.fParticleCount; ++i) {
                temp = this.buildSyntaxTree(group.fParticles[i], forUPA);
                if (temp == null) continue;
                compactedForUPA |= temp.isCompactedForUPA();
                ++count;
                nodeRet = nodeRet == null ? temp : this.fNodeFactory.getCMBinOpNode(group.fCompositor, nodeRet, temp);
            }
            if (nodeRet != null) {
                if (group.fCompositor == 101 && count < group.fParticleCount) {
                    nodeRet = this.fNodeFactory.getCMUniOpNode(5, nodeRet);
                }
                nodeRet = this.expandContentModel(nodeRet, minOccurs, maxOccurs);
                nodeRet.setIsCompactUPAModel(compactedForUPA);
            }
        }
        return nodeRet;
    }

    private CMNode expandContentModel(CMNode node, int minOccurs, int maxOccurs) {
        CMNode nodeRet = null;
        if (minOccurs == 1 && maxOccurs == 1) {
            nodeRet = node;
        } else if (minOccurs == 0 && maxOccurs == 1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(5, node);
        } else if (minOccurs == 0 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(4, node);
        } else if (minOccurs == 1 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(6, node);
        } else if (maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(6, node);
            nodeRet = this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(node, minOccurs - 1, true), nodeRet);
        } else {
            if (minOccurs > 0) {
                nodeRet = this.multiNodes(node, minOccurs, false);
            }
            if (maxOccurs > minOccurs) {
                node = this.fNodeFactory.getCMUniOpNode(5, node);
                nodeRet = nodeRet == null ? this.multiNodes(node, maxOccurs - minOccurs, false) : this.fNodeFactory.getCMBinOpNode(102, nodeRet, this.multiNodes(node, maxOccurs - minOccurs, true));
            }
        }
        return nodeRet;
    }

    private CMNode multiNodes(CMNode node, int num, boolean copyFirst) {
        if (num == 0) {
            return null;
        }
        if (num == 1) {
            return copyFirst ? this.copyNode(node) : node;
        }
        int num1 = num / 2;
        return this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(node, num1, copyFirst), this.multiNodes(node, num - num1, true));
    }

    private CMNode copyNode(CMNode node) {
        int type = node.type();
        if (type == 101 || type == 102) {
            XSCMBinOp bin = (XSCMBinOp)node;
            node = this.fNodeFactory.getCMBinOpNode(type, this.copyNode(bin.getLeft()), this.copyNode(bin.getRight()));
        } else if (type == 4 || type == 6 || type == 5) {
            XSCMUniOp uni = (XSCMUniOp)node;
            node = this.fNodeFactory.getCMUniOpNode(type, this.copyNode(uni.getChild()));
        } else if (type == 1 || type == 2) {
            XSCMLeaf leaf = (XSCMLeaf)node;
            node = this.fNodeFactory.getCMLeafNode(leaf.type(), leaf.getLeaf(), leaf.getParticleId(), this.fLeafCount++);
        }
        return node;
    }

    private CMNode buildCompactSyntaxTree(XSParticleDecl particle) {
        int maxOccurs = particle.fMaxOccurs;
        int minOccurs = particle.fMinOccurs;
        short type = particle.fType;
        CMNode nodeRet = null;
        if (type == 2 || type == 1) {
            return this.buildCompactSyntaxTree2(particle, minOccurs, maxOccurs);
        }
        if (type == 3) {
            XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
            if (group.fParticleCount == 1 && (minOccurs != 1 || maxOccurs != 1)) {
                return this.buildCompactSyntaxTree2(group.fParticles[0], minOccurs, maxOccurs);
            }
            CMNode temp = null;
            int count = 0;
            for (int i = 0; i < group.fParticleCount; ++i) {
                temp = this.buildCompactSyntaxTree(group.fParticles[i]);
                if (temp == null) continue;
                ++count;
                nodeRet = nodeRet == null ? temp : this.fNodeFactory.getCMBinOpNode(group.fCompositor, nodeRet, temp);
            }
            if (nodeRet != null && group.fCompositor == 101 && count < group.fParticleCount) {
                nodeRet = this.fNodeFactory.getCMUniOpNode(5, nodeRet);
            }
        }
        return nodeRet;
    }

    private CMNode buildCompactSyntaxTree2(XSParticleDecl particle, int minOccurs, int maxOccurs) {
        CMNode nodeRet = null;
        if (minOccurs == 1 && maxOccurs == 1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
        } else if (minOccurs == 0 && maxOccurs == 1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            nodeRet = this.fNodeFactory.getCMUniOpNode(5, nodeRet);
        } else if (minOccurs == 0 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            nodeRet = this.fNodeFactory.getCMUniOpNode(4, nodeRet);
        } else if (minOccurs == 1 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            nodeRet = this.fNodeFactory.getCMUniOpNode(6, nodeRet);
        } else {
            nodeRet = this.fNodeFactory.getCMRepeatingLeafNode(particle.fType, particle.fValue, minOccurs, maxOccurs, this.fParticleCount++, this.fLeafCount++);
            nodeRet = minOccurs == 0 ? this.fNodeFactory.getCMUniOpNode(4, nodeRet) : this.fNodeFactory.getCMUniOpNode(6, nodeRet);
        }
        return nodeRet;
    }

    private boolean useRepeatingLeafNodes(XSParticleDecl particle) {
        int maxOccurs = particle.fMaxOccurs;
        int minOccurs = particle.fMinOccurs;
        short type = particle.fType;
        if (type == 3) {
            XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
            if (minOccurs != 1 || maxOccurs != 1) {
                if (group.fParticleCount == 1) {
                    XSParticleDecl particle2 = group.fParticles[0];
                    short type2 = particle2.fType;
                    return (type2 == 1 || type2 == 2) && particle2.fMinOccurs == 1 && particle2.fMaxOccurs == 1;
                }
                return group.fParticleCount == 0;
            }
            for (int i = 0; i < group.fParticleCount; ++i) {
                if (this.useRepeatingLeafNodes(group.fParticles[i])) continue;
                return false;
            }
        }
        return true;
    }

    void testOccurrences(int occurs) {
        this.fNodeFactory.testOccurrences(occurs);
    }
}

