/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Set;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.ModuleErrors;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;

public class ExtensionsErrorsDeclarationEnricher
implements DeclarationEnricher {
    private static String ERROR_MASK = "Trying to add the '%s' Error to the Component '%s' but the Extension doesn't declare it";

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private ErrorModel getErrorModel(ErrorTypeDefinition<?> errorTypeDef, Set<ErrorModel> errors, ComponentDeclaration component) {
        return errors.stream().filter(e -> !e.getNamespace().equals(Errors.CORE_NAMESPACE_NAME) && e.getType().equals(errorTypeDef.getType())).findFirst().orElseThrow(() -> new IllegalModelDefinitionException(String.format(ERROR_MASK, errorTypeDef, component.getName())));
    }

    private class EnricherDelegate
    implements DeclarationEnricher {
        private EnricherDelegate() {
        }

        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            final Set errorModels = extensionDeclaration.getErrorModels();
            new IdempotentDeclarationWalker(){

                public void onOperation(WithOperationsDeclaration owner, OperationDeclaration operationDeclaration) {
                    if (operationDeclaration.getModelProperty(ConnectivityModelProperty.class).isPresent()) {
                        operationDeclaration.addErrorModel(ExtensionsErrorsDeclarationEnricher.this.getErrorModel(ModuleErrors.CONNECTIVITY, errorModels, (ComponentDeclaration)operationDeclaration));
                        operationDeclaration.addErrorModel(ExtensionsErrorsDeclarationEnricher.this.getErrorModel(ModuleErrors.RETRY_EXHAUSTED, errorModels, (ComponentDeclaration)operationDeclaration));
                    }
                }
            }.walk(extensionDeclaration);
        }
    }
}

