/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.model.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.mule.runtime.config.spring.internal.dsl.model.config.ConfigurationPropertiesProvider;
import org.mule.runtime.config.spring.internal.dsl.model.config.ConfigurationProperty;

public class SystemPropertiesConfigurationProvider
implements ConfigurationPropertiesProvider {
    private Map<String, ConfigurationProperty> configurationAttributes = new HashMap<String, ConfigurationProperty>();

    public SystemPropertiesConfigurationProvider() {
        Properties properties = System.getProperties();
        Set<Object> keys = properties.keySet();
        keys.stream().forEach(key -> {
            Object value = properties.get(key);
            if (value != null) {
                String stringKey = key instanceof String ? (String)key : key.toString();
                String stringValue = value instanceof String ? (String)value : value.toString();
                this.configurationAttributes.put(stringKey, new ConfigurationProperty("system property", stringKey, stringValue));
            }
        });
    }

    @Override
    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        return Optional.ofNullable(this.configurationAttributes.get(configurationAttributeKey));
    }

    @Override
    public String getDescription() {
        return "system properties provider";
    }
}

