/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.utils;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;

public abstract class TypePromoter {
    private Class<? extends AnyType> targetType = null;

    public abstract AnyAtomicType doPromote(AnyAtomicType var1) throws DynamicError;

    public final AnyAtomicType promote(AnyType value) throws DynamicError {
        if (value.getClass() == this.getTargetType()) {
            return (AnyAtomicType)value;
        }
        AnyAtomicType atomized = this.atomize(value);
        if (atomized == null) {
            return null;
        }
        return this.doPromote(atomized);
    }

    protected abstract Class<? extends AnyType> substitute(Class<? extends AnyType> var1);

    protected abstract boolean checkCombination(Class<? extends AnyType> var1);

    public void considerType(Class<? extends AnyType> typeToConsider) throws DynamicError {
        Class<? extends AnyType> baseType = this.substitute(typeToConsider);
        if (baseType == null) {
            throw DynamicError.argument_type_error(typeToConsider);
        }
        if (this.targetType == null) {
            this.targetType = baseType;
        } else if (!this.checkCombination(baseType)) {
            throw DynamicError.argument_type_error(typeToConsider);
        }
    }

    public void considerTypes(Collection<? extends Class<? extends AnyType>> typesToConsider) throws DynamicError {
        Iterator<? extends Class<? extends AnyType>> iter = typesToConsider.iterator();
        while (iter.hasNext()) {
            this.considerType(iter.next());
        }
    }

    public void considerSequence(ResultSequence sequenceToConsider) throws DynamicError {
        for (int i = 0; i < sequenceToConsider.size(); ++i) {
            Item item = sequenceToConsider.item(i);
            this.considerValue(item);
        }
    }

    public Class<? extends AnyType> getTargetType() {
        return this.targetType;
    }

    protected void setTargetType(Class<? extends AnyType> class1) {
        this.targetType = class1;
    }

    public AnyAtomicType atomize(Item at) {
        if (at instanceof NodeType) {
            ResultSequence nodeValues = ((NodeType)at).typed_value();
            if (nodeValues.empty()) {
                return null;
            }
            return (AnyAtomicType)nodeValues.first();
        }
        return (AnyAtomicType)at;
    }

    public void considerValue(Item at) throws DynamicError {
        AnyAtomicType atomize = this.atomize(at);
        if (atomize != null) {
            this.considerType(atomize.getClass());
        }
    }
}

