/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.TransactionFactory;

public class SingleResourceTransactionFactoryManager {
    private Map<Class, TransactionFactory> transactionFactories = new HashMap<Class, TransactionFactory>();
    private Map<Class, TransactionFactory> transactionFactoriesCache = new HashMap<Class, TransactionFactory>();

    public void registerTransactionFactory(Class supportedType, TransactionFactory transactionFactory) {
        this.transactionFactories.put(supportedType, transactionFactory);
    }

    public boolean supports(Class type) {
        return this.transactionFactories.containsKey(type);
    }

    public TransactionFactory getTransactionFactoryFor(Class type) {
        TransactionFactory transactionFactory = this.transactionFactoriesCache.get(type);
        if (transactionFactory == null) {
            for (Class transactionResourceType : this.transactionFactories.keySet()) {
                if (!transactionResourceType.isAssignableFrom(type)) continue;
                transactionFactory = this.transactionFactories.get(transactionResourceType);
                this.transactionFactoriesCache.put(type, transactionFactory);
                break;
            }
        }
        if (transactionFactory == null) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("No %s for transactional resource %s", TransactionFactory.class.getName(), type.getName())));
        }
        return transactionFactory;
    }
}

