/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.component.InternalComponent;
import org.mule.runtime.core.api.store.AbstractPartitionableObjectStore;
import org.mule.runtime.core.api.store.PartitionableExpirableObjectStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedInMemoryObjectStore<T extends Serializable>
extends AbstractPartitionableObjectStore<T>
implements PartitionableExpirableObjectStore<T>,
InternalComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionedInMemoryObjectStore.class);
    private ConcurrentMap<String, ConcurrentMap<String, T>> partitions = new ConcurrentHashMap<String, ConcurrentMap<String, T>>();
    private ConcurrentMap<String, ConcurrentLinkedQueue<ExpiryEntry>> expiryInfoPartition = new ConcurrentHashMap<String, ConcurrentLinkedQueue<ExpiryEntry>>();

    public boolean isPersistent() {
        return false;
    }

    @Override
    protected boolean doContains(String key, String partitionName) throws ObjectStoreException {
        if (this.partitions.containsKey(partitionName)) {
            return ((ConcurrentMap)this.partitions.get(partitionName)).containsKey(key);
        }
        return false;
    }

    @Override
    protected void doStore(String key, T value, String partitionName) throws ObjectStoreException {
        Serializable oldValue = (Serializable)this.getPartition(partitionName).putIfAbsent(key, value);
        if (oldValue != null) {
            throw new ObjectAlreadyExistsException();
        }
        this.getExpiryInfoPartition(partitionName).add(new ExpiryEntry(this.getCurrentNanoTime(), (Serializable)((Object)key)));
    }

    @Override
    protected T doRetrieve(String key, String partitionName) throws ObjectStoreException {
        Serializable value = (Serializable)this.getPartition(partitionName).get(key);
        if (value == null) {
            throw new ObjectDoesNotExistException();
        }
        return (T)value;
    }

    @Override
    protected T doRemove(String key, String partitionName) throws ObjectStoreException {
        Serializable removedValue = (Serializable)this.getPartition(partitionName).remove(key);
        if (removedValue == null) {
            throw new ObjectDoesNotExistException();
        }
        Iterator<ExpiryEntry> iterator = this.getExpiryInfoPartition(partitionName).iterator();
        while (iterator.hasNext()) {
            ExpiryEntry entry = iterator.next();
            if (!key.equals(entry.getKey())) continue;
            iterator.remove();
            break;
        }
        return (T)removedValue;
    }

    public List<String> allKeys(String partitionName) throws ObjectStoreException {
        return new ArrayList<String>(this.getPartition(partitionName).keySet());
    }

    public void clear(String partitionName) throws ObjectStoreException {
        this.getPartition(partitionName).clear();
    }

    public List<String> allPartitions() throws ObjectStoreException {
        return new ArrayList<String>(this.partitions.keySet());
    }

    private ConcurrentMap<String, T> getPartition(String partitionName) {
        ConcurrentMap previous;
        ConcurrentMap partition = (ConcurrentHashMap)this.partitions.get(partitionName);
        if (partition == null && (previous = (ConcurrentMap)this.partitions.putIfAbsent(partitionName, partition = new ConcurrentHashMap())) != null) {
            partition = previous;
        }
        return partition;
    }

    private ConcurrentLinkedQueue<ExpiryEntry> getExpiryInfoPartition(String partitionName) {
        ConcurrentLinkedQueue previous;
        ConcurrentLinkedQueue partition = (ConcurrentLinkedQueue)this.expiryInfoPartition.get(partitionName);
        if (partition == null && (previous = this.expiryInfoPartition.putIfAbsent(partitionName, partition = new ConcurrentLinkedQueue())) != null) {
            partition = previous;
        }
        return partition;
    }

    public void open(String partitionName) throws ObjectStoreException {
    }

    public void close(String partitionName) throws ObjectStoreException {
    }

    @Override
    public void expire(long entryTTL, int maxEntries) throws ObjectStoreException {
        this.expire(entryTTL, maxEntries, "DEFAULT_PARTITION");
    }

    @Override
    public void expire(long entryTTL, int maxEntries, String partitionName) throws ObjectStoreException {
        ExpiryEntry oldestEntry;
        long now = this.getCurrentNanoTime();
        int expiredEntries = 0;
        ConcurrentLinkedQueue<ExpiryEntry> store = this.getExpiryInfoPartition(partitionName);
        ConcurrentMap<String, T> partition = this.getPartition(partitionName);
        this.trimToMaxSize(store, maxEntries, partition);
        if (entryTTL == 0L) {
            return;
        }
        while ((oldestEntry = store.peek()) != null && TimeUnit.NANOSECONDS.toMillis(now - oldestEntry.getTime()) >= entryTTL) {
            oldestEntry = (ExpiryEntry)store.remove();
            partition.remove(oldestEntry.getKey());
            ++expiredEntries;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Expired " + expiredEntries + " old entries");
        }
    }

    private void trimToMaxSize(ConcurrentLinkedQueue<ExpiryEntry> store, int maxEntries, ConcurrentMap<String, T> partition) {
        if (maxEntries == 0) {
            return;
        }
        int currentSize = store.size();
        int excess = currentSize - maxEntries;
        if (excess > 0) {
            while (currentSize > maxEntries) {
                ExpiryEntry toRemove = (ExpiryEntry)store.remove();
                partition.remove(toRemove.getKey());
                --currentSize;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Expired " + excess + " excess entries");
            }
        }
    }

    public void disposePartition(String partitionName) throws ObjectStoreException {
        ConcurrentLinkedQueue entries;
        Map partition = (Map)this.partitions.remove(partitionName);
        if (partition != null) {
            partition.clear();
        }
        if ((entries = (ConcurrentLinkedQueue)this.expiryInfoPartition.remove(partitionName)) != null) {
            entries.clear();
        }
    }

    protected long getCurrentNanoTime() {
        return System.nanoTime();
    }

    private static class ExpiryEntry {
        private final long time;
        private final Serializable key;

        public ExpiryEntry(long time, Serializable key) {
            this.time = time;
            this.key = key;
        }

        public long getTime() {
            return this.time;
        }

        public Serializable getKey() {
            return this.key;
        }
    }
}

