/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel;

import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.el.mvel.MessageVariableResolverFactory;
import org.mule.runtime.core.el.mvel.MuleImmutableVariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventVariableResolverFactory
extends MessageVariableResolverFactory {
    private static final Logger logger = LoggerFactory.getLogger(EventVariableResolverFactory.class);
    private static final long serialVersionUID = -6819292692339684915L;
    private final String FLOW = "flow";
    private String flowName;

    public EventVariableResolverFactory(ParserConfiguration parserConfiguration, MuleContext muleContext, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation) {
        super(parserConfiguration, muleContext, event, eventBuilder);
        this.flowName = componentLocation != null ? componentLocation.getRootContainerName() : null;
    }

    public EventVariableResolverFactory(ParserConfiguration parserConfiguration, MuleContext muleContext, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, VariableResolverFactory next) {
        this(parserConfiguration, muleContext, event, eventBuilder, componentLocation);
        this.setNextFactory(next);
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.event != null) {
            if ("flow".equals(name) && this.flowName != null) {
                return new MuleImmutableVariableResolver<FlowContext>("flow", new FlowContext(this.flowName), null);
            }
            if ("_muleEvent".equals(name)) {
                return new MuleImmutableVariableResolver<InternalEvent>("_muleEvent", this.event, null);
            }
        }
        return super.getVariableResolver(name);
    }

    @Override
    public boolean isTarget(String name) {
        boolean isDeprecatedVariable = "_muleEvent".equals(name);
        if (isDeprecatedVariable) {
            logger.warn(String.format("Variable %s has been removed from MEL and will not work outside of compatibility mode.", "_muleEvent"));
        }
        return isDeprecatedVariable || "flow".equals(name) || super.isTarget(name);
    }

    public static class FlowContext {
        private final String flowConstructName;

        public FlowContext(String flowConstructName) {
            this.flowConstructName = flowConstructName;
        }

        public String getName() {
            return this.flowConstructName;
        }
    }
}

