/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel;

import java.lang.reflect.Method;
import org.mule.mvel2.ImmutableElementException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.ast.FunctionInstance;
import org.mule.mvel2.compiler.AbstractParser;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;
import org.mule.runtime.core.api.el.VariableAssignmentCallback;
import org.mule.runtime.core.el.mvel.MVELFunctionAdaptor;
import org.mule.runtime.core.el.mvel.MuleAliasVariableResolver;
import org.mule.runtime.core.el.mvel.MuleBaseVariableResolverFactory;
import org.mule.runtime.core.el.mvel.MuleVariableResolver;

public class MVELExpressionLanguageContext
extends MuleBaseVariableResolverFactory
implements ExpressionLanguageContext {
    private static final long serialVersionUID = 909413730991198290L;
    public static final String MULE_MESSAGE_INTERNAL_VARIABLE = "_muleMessage";
    public static final String MULE_EVENT_INTERNAL_VARIABLE = "_muleEvent";
    public static final String MULE_CONTEXT_INTERNAL_VARIABLE = "_muleContext";
    protected ParserConfiguration parserConfiguration;
    protected MuleContext muleContext;

    public MVELExpressionLanguageContext(ParserConfiguration parserConfiguration, MuleContext muleContext) {
        this.parserConfiguration = parserConfiguration;
        this.muleContext = muleContext;
    }

    public MVELExpressionLanguageContext(MVELExpressionLanguageContext context) {
        this.parserConfiguration = context.parserConfiguration;
        this.muleContext = context.muleContext;
        this.nextFactory = context.nextFactory;
        this.variableResolvers = context.variableResolvers;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        Object variableResolver = super.getVariableResolver(name);
        if (variableResolver instanceof MuleAliasVariableResolver) {
            variableResolver = new MuleAliasVariableResolver((MuleAliasVariableResolver)((Object)variableResolver), this);
        }
        return variableResolver;
    }

    @Override
    public <T> void addVariable(String name, T value) {
        this.addResolver(name, (VariableResolver)new MuleVariableResolver<T>(name, value, value != null ? value.getClass() : null, null));
    }

    @Override
    public <T> void addVariable(String name, T value, VariableAssignmentCallback<T> assignmentCallback) {
        this.addResolver(name, (VariableResolver)new MuleVariableResolver<T>(name, value, value != null ? value.getClass() : null, assignmentCallback));
    }

    @Override
    public <T> void addFinalVariable(String name, T value) {
        this.addVariable(name, value, new VariableAssignmentCallback<T>(){

            @Override
            public void assignValue(String name, T value, T newValue) {
                throw new ImmutableElementException(CoreMessages.expressionFinalVariableCannotBeAssignedValue(name).getMessage());
            }
        });
    }

    @Override
    public <T> T getVariable(String name) {
        VariableResolver resolver = this.getVariableResolver(name);
        if (resolver != null) {
            return (T)resolver.getValue();
        }
        return null;
    }

    @Override
    public <T> T getVariable(String name, Class<T> type) {
        return this.getVariable(name);
    }

    @Override
    public void addAlias(String alias, String expression) {
        this.addResolver(alias, (VariableResolver)new MuleAliasVariableResolver(alias, expression, this, this.parserConfiguration));
    }

    @Override
    public void importClass(Class<?> clazz) {
        if (this.parserConfiguration.hasImport(clazz.getSimpleName())) {
            this.parserConfiguration.addImport(clazz);
        }
    }

    @Override
    public void importClass(String name, Class<?> clazz) {
        if (!this.parserConfiguration.hasImport(name)) {
            this.parserConfiguration.addImport(name, clazz);
        }
    }

    @Override
    public void importStaticMethod(String name, Method method) {
        if (!this.parserConfiguration.hasImport(name)) {
            this.parserConfiguration.addImport(name, method);
        }
    }

    @Override
    public boolean contains(String name) {
        return this.isResolveable(name);
    }

    @Override
    public void declareFunction(String name, ExpressionLanguageFunction function) {
        try {
            this.addFinalVariable(name, new FunctionInstance((Function)new MVELFunctionAdaptor(name, function, new ParserContext(this.parserConfiguration))));
        }
        finally {
            AbstractParser.resetParserContext();
        }
    }
}

