/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle.phases;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.PreDestroy;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.Component;
import org.mule.runtime.core.api.config.Config;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleObject;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.routing.OutboundRouter;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transport.LegacyConnector;
import org.mule.runtime.core.internal.lifecycle.phases.DefaultLifecyclePhase;
import org.mule.runtime.core.privileged.util.annotation.AnnotationMetaData;
import org.mule.runtime.core.privileged.util.annotation.AnnotationUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;

public class MuleContextDisposePhase
extends DefaultLifecyclePhase {
    public MuleContextDisposePhase() {
        super("dispose", Disposable.class, "initialise");
        LinkedHashSet<LifecycleObject> orderedObjects = new LinkedHashSet<LifecycleObject>();
        orderedObjects.add(new LifecycleObject(FlowConstruct.class));
        orderedObjects.add(new LifecycleObject(LegacyConnector.class));
        orderedObjects.add(new LifecycleObject(ConfigurationProvider.class));
        orderedObjects.add(new LifecycleObject(Config.class));
        orderedObjects.add(new LifecycleObject(Disposable.class));
        orderedObjects.add(new LifecycleObject(Object.class));
        this.registerSupportedPhase("all");
        this.setOrderedLifecycleObjects(orderedObjects);
        this.setIgnoredObjectTypes(new Class[]{Component.class, MessageSource.class, InterceptingMessageProcessor.class, OutboundRouter.class, Transformer.class, MuleContext.class});
    }

    @Override
    public void applyLifecycle(Object o) throws LifecycleException {
        block7: {
            if (o == null) {
                return;
            }
            if (this.ignoreType(o.getClass())) {
                return;
            }
            try {
                super.applyLifecycle(o);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block7;
                this.logger.warn("Failed to dispose object " + o, (Throwable)e);
            }
        }
        List<AnnotationMetaData> annos = AnnotationUtils.getMethodAnnotations(o.getClass(), PreDestroy.class);
        if (annos.size() == 0) {
            return;
        }
        AnnotationMetaData anno = annos.get(0);
        try {
            ((Method)anno.getMember()).invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(anno == null ? "null" : anno.getMember().getName(), o), (Throwable)e, (Object)this);
        }
    }
}

