/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.chain;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ModuleOperationMessageProcessorChainBuilder
extends DefaultMessageProcessorChainBuilder {
    public static final String MODULE_CONFIG_GLOBAL_ELEMENT_NAME = "config";
    private Map<String, String> properties;
    private Map<String, String> parameters;
    private ExtensionModel extensionModel;
    private OperationModel operationModel;
    private ExpressionManager expressionManager;

    public ModuleOperationMessageProcessorChainBuilder(Map<String, String> properties, Map<String, String> parameters, ExtensionModel extensionModel, OperationModel operationModel, ExpressionManager expressionManager) {
        this.properties = properties;
        this.parameters = parameters;
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.expressionManager = expressionManager;
    }

    @Override
    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorForLifecycle) {
        return new ModuleOperationProcessorChain("wrapping-operation-module-chain", head, processors, processorForLifecycle, this.properties, this.parameters, this.extensionModel, this.operationModel, this.expressionManager);
    }

    public static class ModuleOperationProcessorChain
    extends DefaultMessageProcessorChainBuilder.DefaultMessageProcessorChain
    implements Processor {
        private Map<String, Pair<String, MetadataType>> properties;
        private Map<String, Pair<String, MetadataType>> parameters;
        private boolean returnsVoid;
        private ExpressionManager expressionManager;
        private Optional<String> target;
        private String targetValue;

        ModuleOperationProcessorChain(String name, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle, Map<String, String> properties, Map<String, String> parameters, ExtensionModel extensionModel, OperationModel operationModel, ExpressionManager expressionManager) {
            super(name, Optional.empty(), head, processors, processorsForLifecycle);
            List propertiesModels = extensionModel.getConfigurationModel(ModuleOperationMessageProcessorChainBuilder.MODULE_CONFIG_GLOBAL_ELEMENT_NAME).isPresent() ? ((ConfigurationModel)extensionModel.getConfigurationModel(ModuleOperationMessageProcessorChainBuilder.MODULE_CONFIG_GLOBAL_ELEMENT_NAME).get()).getAllParameterModels() : Collections.EMPTY_LIST;
            this.properties = this.parseParameters(properties, propertiesModels);
            this.target = parameters.containsKey("target") ? Optional.of(parameters.remove("target")) : Optional.empty();
            this.targetValue = parameters.remove("targetValue");
            this.parameters = this.parseParameters(parameters, operationModel.getAllParameterModels());
            this.returnsVoid = MetadataTypeUtils.isVoid((MetadataType)operationModel.getOutput().getType());
            this.expressionManager = expressionManager;
        }

        private Map<String, Pair<String, MetadataType>> parseParameters(Map<String, String> parameters, List<ParameterModel> parameterModels) {
            HashMap<String, Pair<String, MetadataType>> result = new HashMap<String, Pair<String, MetadataType>>();
            for (ParameterModel parameterModel : parameterModels) {
                String parameterName = parameterModel.getName();
                if (!parameters.containsKey(parameterName)) continue;
                String xmlValue = parameters.get(parameterName);
                result.put(parameterName, (Pair<String, MetadataType>)new Pair((Object)xmlValue, (Object)parameterModel.getType()));
            }
            return result;
        }

        @Override
        public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
            return Flux.from(publisher).concatMap(request -> Flux.just((Object)request).map(this::createEventWithParameters).transform(x$0 -> super.apply((Publisher<InternalEvent>)x$0)).map(eventResult -> this.processResult((InternalEvent)request, (InternalEvent)eventResult)));
        }

        private InternalEvent processResult(InternalEvent originalEvent, InternalEvent chainEvent) {
            if (!this.returnsVoid) {
                originalEvent = this.createNewEventFromJustMessage(originalEvent, chainEvent);
            }
            return originalEvent;
        }

        private InternalEvent createNewEventFromJustMessage(InternalEvent request, InternalEvent response) {
            InternalEvent.Builder builder = InternalEvent.builder(request);
            if (this.target.isPresent()) {
                TypedValue result = this.expressionManager.evaluate(this.targetValue, BindingContextUtils.getTargetBindingContext((Message)response.getMessage()));
                builder.addVariable(this.target.get(), result.getValue(), result.getDataType());
            } else {
                builder.message(InternalMessage.builder(response.getMessage()).build());
            }
            return builder.build();
        }

        private InternalEvent createEventWithParameters(InternalEvent event) {
            InternalEvent.Builder builder = InternalEvent.builder(event.getContext());
            builder.message(InternalMessage.builder().nullValue().build());
            builder.parameters(this.evaluateParameters(event, this.parameters));
            builder.properties(this.evaluateParameters(event, this.properties));
            return builder.build();
        }

        private Map<String, Object> evaluateParameters(InternalEvent event, Map<String, Pair<String, MetadataType>> unevaluatedMap) {
            return unevaluatedMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.expressionManager.isExpression((String)((Pair)entry.getValue()).getFirst()) ? this.getEvaluatedValue(event, (String)((Pair)entry.getValue()).getFirst(), (MetadataType)((Pair)entry.getValue()).getSecond()) : ((Pair)entry.getValue()).getFirst()));
        }

        private Object getEvaluatedValue(InternalEvent event, String value, MetadataType metadataType) {
            Object evaluatedResult;
            ComponentLocation headLocation = null;
            Processor head = this.getProcessorsToExecute().get(0);
            headLocation = ((AnnotatedObject)head).getLocation();
            if (MetadataFormat.JAVA.equals((Object)metadataType.getMetadataFormat())) {
                evaluatedResult = this.expressionManager.evaluate(value, event, headLocation).getValue();
            } else {
                String mediaType = (String)metadataType.getMetadataFormat().getValidMimeTypes().iterator().next();
                DataType expectedOutputType = DataType.builder().type(String.class).mediaType(mediaType).charset(StandardCharsets.UTF_8).build();
                evaluatedResult = this.expressionManager.evaluate(value, expectedOutputType, BindingContextUtils.NULL_BINDING_CONTEXT, event, headLocation, false).getValue();
            }
            return evaluatedResult;
        }
    }
}

