/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.AbstractMuleObjectOwner;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Router;
import org.mule.runtime.core.api.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.component.ComponentUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UntilSuccessful
extends AbstractMuleObjectOwner
implements Router {
    private static final String UNTIL_SUCCESSFUL_MSG_PREFIX = "'until-successful' retries exhausted. Last exception message was: %s";
    private static final long DEFAULT_MILLIS_BETWEEN_RETRIES = 60000L;
    private static final int DEFAULT_RETRIES = 5;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    private int maxRetries = 5;
    private Long millisBetweenRetries = 60000L;
    private MessageProcessorChain nestedChain;
    private Predicate<InternalEvent> shouldRetry;
    private SimpleRetryPolicyTemplate policyTemplate;
    private Scheduler timer;
    private ProcessingStrategy processingStrategy;
    private List<Processor> processors;

    @Override
    public void initialise() throws InitialisationException {
        if (this.processors == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"One message processor must be configured within 'until-successful'."), (Initialisable)this);
        }
        this.nestedChain = MessageProcessors.newChain(MessageProcessors.getProcessingStrategy(this.muleContext, this.getRootContainerName()), this.processors);
        super.initialise();
        this.timer = this.muleContext.getSchedulerService().cpuLightScheduler();
        this.policyTemplate = new SimpleRetryPolicyTemplate(this.millisBetweenRetries, this.maxRetries);
        this.shouldRetry = event -> event.getError().isPresent();
        Object rootContainer = ComponentUtils.getFromAnnotatedObject(this.componentLocator, (AnnotatedObject)this).orElse(null);
        this.processingStrategy = rootContainer instanceof FlowConstruct ? ((FlowConstruct)rootContainer).getProcessingStrategy() : DirectProcessingStrategyFactory.DIRECT_PROCESSING_STRATEGY_INSTANCE;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.timer.stop();
    }

    @Override
    public InternalEvent process(InternalEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        return Flux.from(publisher).flatMap(event -> Mono.from(MessageProcessors.processWithChildContext(event, this.scheduleRoute(p -> Mono.from((Publisher)p).transform((Function)this.nestedChain)), Optional.ofNullable(this.getLocation()))).transform(p -> this.policyTemplate.applyPolicy((Publisher)p, this.getRetryPredicate(), e -> {}, this.getThrowableFunction((InternalEvent)event))));
    }

    private Predicate<Throwable> getRetryPredicate() {
        return e -> e instanceof MessagingException && this.shouldRetry.test(((MessagingException)((Object)((Object)e))).getEvent());
    }

    private Function<Throwable, Throwable> getThrowableFunction(InternalEvent event) {
        return throwable -> {
            Throwable cause = ExceptionUtils.getMessagingExceptionCause(throwable);
            return new MessagingException(event, (Throwable)((Object)new RetryPolicyExhaustedException(I18nMessageFactory.createStaticMessage((String)UNTIL_SUCCESSFUL_MSG_PREFIX, (Object[])new Object[]{cause.getMessage()}), cause, this)), (AnnotatedObject)this);
        };
    }

    private ReactiveProcessor scheduleRoute(ReactiveProcessor route) {
        return publisher -> Flux.from((Publisher)publisher).transform((Function)this.processingStrategy.onPipeline(route));
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getMillisBetweenRetries() {
        return this.millisBetweenRetries;
    }

    public void setMillisBetweenRetries(long millisBetweenRetries) {
        this.millisBetweenRetries = millisBetweenRetries;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    protected List<Object> getOwnedObjects() {
        return Collections.singletonList(this.nestedChain);
    }
}

