/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.streaming.exception.StreamingBufferSizeExceededException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.internal.streaming.bytes.AbstractInputStreamBuffer;

public class InMemoryStreamBuffer
extends AbstractInputStreamBuffer {
    private static final int STREAM_FINISHED_PROBE = 10;
    private final int bufferSizeIncrement;
    private final int maxBufferSize;
    private long bufferTip = 0L;
    private boolean streamFullyConsumed = false;

    public InMemoryStreamBuffer(InputStream stream, InMemoryCursorStreamConfig config, ByteBufferManager bufferManager) {
        super(stream, bufferManager, config.getInitialBufferSize().toBytes());
        this.bufferSizeIncrement = config.getBufferSizeIncrement() != null ? config.getBufferSizeIncrement().toBytes() : 0;
        this.maxBufferSize = config.getMaxBufferSize().toBytes();
    }

    @Override
    protected ByteBuffer doGet(long position, int length) {
        return this.doGet(position, length, true);
    }

    private ByteBuffer doGet(long position, int length, boolean consumeStreamIfNecessary) {
        return this.withReadLock(releaser -> {
            ByteBuffer presentRead = this.getFromCurrentData(position, length);
            if (presentRead != null) {
                return presentRead;
            }
            if (consumeStreamIfNecessary) {
                releaser.release();
                return this.withWriteLock(() -> {
                    ByteBuffer refetch = this.getFromCurrentData(position, length);
                    if (refetch != null) {
                        return refetch;
                    }
                    long requiredUpperBound = position + (long)length;
                    while (!this.isStreamFullyConsumed() && this.bufferTip < requiredUpperBound) {
                        try {
                            int read = this.consumeForwardData();
                            if (read > 0) {
                                refetch = this.getFromCurrentData(position, Math.min(length, read));
                                if (refetch == null) continue;
                                return refetch;
                            }
                            this.streamFullyConsumed();
                            ((ByteBuffer)this.buffer.get()).limit(((ByteBuffer)this.buffer.get()).position());
                        }
                        catch (IOException e) {
                            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not read stream"), (Throwable)e);
                        }
                    }
                    return this.doGet(position, length, false);
                });
            }
            return this.getFromCurrentData(position, length);
        });
    }

    private ByteBuffer getFromCurrentData(long position, int length) {
        if (this.isStreamFullyConsumed() && position > this.bufferTip) {
            return null;
        }
        if (position < this.bufferTip) {
            length = Math.min(length, Math.toIntExact(this.bufferTip - position));
            return this.copy(position, length);
        }
        return null;
    }

    @Override
    public void doClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int consumeForwardData() throws IOException {
        int read;
        ByteBuffer b = (ByteBuffer)this.buffer.get();
        ByteBuffer readBuffer = b.hasRemaining() ? b : this.bufferManager.allocate(this.bufferSizeIncrement > 0 ? this.bufferSizeIncrement : 10);
        boolean auxBuffer = readBuffer != b;
        try {
            read = this.consumeStream(readBuffer);
            if (read > 0) {
                if (auxBuffer) {
                    b = this.expandBuffer();
                    readBuffer.flip();
                    b.put(readBuffer);
                    this.buffer = new LazyValue((Object)b);
                }
                this.bufferTip += (long)read;
            } else {
                this.streamFullyConsumed = true;
            }
        }
        finally {
            if (auxBuffer) {
                this.bufferManager.deallocate(readBuffer);
            }
        }
        return read;
    }

    private ByteBuffer expandBuffer() {
        ByteBuffer b = (ByteBuffer)this.buffer.get();
        int newSize = b.capacity() + this.bufferSizeIncrement;
        if (!this.canBeExpandedTo(newSize)) {
            throw new StreamingBufferSizeExceededException(this.maxBufferSize);
        }
        ByteBuffer newBuffer = this.bufferManager.allocate(newSize);
        b.position(0);
        newBuffer.put(b);
        ByteBuffer oldBuffer = b;
        b = newBuffer;
        this.buffer = new LazyValue((Object)b);
        this.deallocate(oldBuffer);
        return b;
    }

    @Override
    protected boolean canDoSoftCopy() {
        return this.streamFullyConsumed || ((ByteBuffer)this.buffer.get()).capacity() >= this.maxBufferSize || this.bufferSizeIncrement == 0;
    }

    private boolean canBeExpandedTo(int newSize) {
        if (this.bufferSizeIncrement <= 0) {
            return false;
        }
        if (this.maxBufferSize == 0) {
            return true;
        }
        return newSize <= this.maxBufferSize;
    }
}

