/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.internal.util.queue.QueueFileProvider;
import org.mule.runtime.core.internal.util.queue.RawDataSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RandomAccessFileQueueStore {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final int CONTROL_DATA_SIZE = 5;
    private static final byte NOT_REMOVED = 0;
    private static final byte REMOVED = 1;
    private final QueueFileProvider queueFileProvider;
    private LinkedList<Long> orderedKeys = new LinkedList();
    private long fileTotalSpace = 0L;

    public RandomAccessFileQueueStore(QueueFileProvider queueFileProvider) {
        this.queueFileProvider = queueFileProvider;
        this.initialise();
    }

    public File getFile() {
        return this.queueFileProvider.getFile();
    }

    public synchronized void addLast(byte[] element) {
        long filePointer = this.writeData(element);
        this.orderedKeys.addLast(filePointer);
    }

    public synchronized byte[] removeFirst() throws InterruptedException {
        try {
            if (this.orderedKeys.isEmpty()) {
                return null;
            }
            Long filePosition = this.orderedKeys.getFirst();
            this.queueFileProvider.getRandomAccessFile().seek(filePosition);
            this.queueFileProvider.getRandomAccessFile().writeByte(1);
            byte[] data = this.readDataInCurrentPosition();
            this.orderedKeys.removeFirst();
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized byte[] getFirst() throws InterruptedException {
        return this.readFirstValue();
    }

    public synchronized void addFirst(byte[] item) throws InterruptedException {
        this.orderedKeys.addFirst(this.writeData(item));
    }

    public int getSize() {
        return this.orderedKeys.size();
    }

    public synchronized void clear() {
        try {
            this.queueFileProvider.getRandomAccessFile().close();
            this.orderedKeys.clear();
            this.fileTotalSpace = 0L;
            this.queueFileProvider.recreate();
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public synchronized boolean addAll(Collection<? extends byte[]> items) {
        for (byte[] byArray : items) {
            this.addLast(byArray);
        }
        return true;
    }

    public synchronized Collection<byte[]> allElements() {
        LinkedList<byte[]> elements = new LinkedList<byte[]>();
        try {
            this.queueFileProvider.getRandomAccessFile().seek(0L);
            while (true) {
                boolean removed;
                if (!(removed = this.queueFileProvider.getRandomAccessFile().readBoolean())) {
                    elements.add(this.readDataInCurrentPosition());
                    continue;
                }
                this.moveFilePointerToNextData();
            }
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Error reading queue elements", (Throwable)e);
            }
            return elements;
        }
    }

    public boolean isEmpty() {
        return this.orderedKeys.isEmpty();
    }

    public synchronized boolean remove(RawDataSelector rawDataSelector) {
        try {
            long currentPosition;
            byte[] data;
            byte removed;
            this.queueFileProvider.getRandomAccessFile().seek(0L);
            do {
                currentPosition = this.queueFileProvider.getRandomAccessFile().getFilePointer();
            } while ((removed = this.queueFileProvider.getRandomAccessFile().readByte()) != 0 || !rawDataSelector.isSelectedData(data = this.readDataInCurrentPosition()));
            this.queueFileProvider.getRandomAccessFile().seek(currentPosition);
            this.queueFileProvider.getRandomAccessFile().writeByte(1);
            this.orderedKeys.remove(currentPosition);
            return true;
        }
        catch (EOFException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Error removing queue element", (Throwable)e);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close() {
        try {
            this.queueFileProvider.close();
        }
        catch (IOException e) {
            this.logAndIgnore(e);
        }
    }

    private void logAndIgnore(IOException e) {
        this.logger.warn(e.getMessage());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Error closing queue store", (Throwable)e);
        }
    }

    public synchronized void delete() {
        this.queueFileProvider.delete();
    }

    private byte[] readDataInCurrentPosition() throws IOException {
        int serializedValueSize = this.queueFileProvider.getRandomAccessFile().readInt();
        byte[] data = new byte[serializedValueSize];
        this.queueFileProvider.getRandomAccessFile().read(data, 0, serializedValueSize);
        return data;
    }

    private long writeData(byte[] data) {
        try {
            if (this.getSize() > 0) {
                this.queueFileProvider.getRandomAccessFile().seek(this.fileTotalSpace);
            }
            long filePointer = this.queueFileProvider.getRandomAccessFile().getFilePointer();
            int totalBytesRequired = 5 + data.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(totalBytesRequired);
            byteBuffer.put((byte)0);
            byteBuffer.putInt(data.length);
            byteBuffer.put(data);
            this.queueFileProvider.getRandomAccessFile().write(byteBuffer.array());
            this.fileTotalSpace += (long)totalBytesRequired;
            return filePointer;
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private void initialise() {
        try {
            this.queueFileProvider.getRandomAccessFile().seek(0L);
            while (true) {
                long position = this.queueFileProvider.getRandomAccessFile().getFilePointer();
                byte removed = this.queueFileProvider.getRandomAccessFile().readByte();
                if (removed == 0) {
                    this.orderedKeys.add(position);
                    this.moveFilePointerToNextData();
                    continue;
                }
                this.moveFilePointerToNextData();
            }
        }
        catch (EOFException e) {
            try {
                this.fileTotalSpace = this.queueFileProvider.getRandomAccessFile().length();
            }
            catch (IOException ioe) {
                throw new MuleRuntimeException((Throwable)e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Error initializing queue store", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private byte[] readFirstValue() {
        try {
            if (this.orderedKeys.isEmpty()) {
                return null;
            }
            Long filePointer = this.orderedKeys.getFirst();
            this.queueFileProvider.getRandomAccessFile().seek(filePointer);
            this.queueFileProvider.getRandomAccessFile().readByte();
            return this.readDataInCurrentPosition();
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private void moveFilePointerToNextData() throws IOException {
        int serializedValueSize = this.queueFileProvider.getRandomAccessFile().readInt();
        this.queueFileProvider.getRandomAccessFile().seek(this.queueFileProvider.getRandomAccessFile().getFilePointer() + (long)serializedValueSize);
    }

    public long getLength() {
        return this.fileTotalSpace;
    }

    public synchronized boolean contains(RawDataSelector rawDataSelector) {
        try {
            this.queueFileProvider.getRandomAccessFile().seek(0L);
            while (true) {
                byte removed;
                if ((removed = this.queueFileProvider.getRandomAccessFile().readByte()) == 0) {
                    byte[] data = this.readDataInCurrentPosition();
                    if (!rawDataSelector.isSelectedData(data)) continue;
                    return true;
                }
                this.moveFilePointerToNextData();
            }
        }
        catch (EOFException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Cannot determine if element is contained in the queue store", (Throwable)e);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

