/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.component;

import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.execution.ExecutableComponent;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.InputEvent;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.InternalEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import reactor.core.publisher.Mono;

public abstract class AbstractExecutableComponent
extends AbstractAnnotatedObject
implements ExecutableComponent {
    @Inject
    protected MuleContext muleContext;

    public final CompletableFuture<Event> execute(InputEvent inputEvent) {
        InternalEvent.Builder builder = InternalEvent.builder(this.createEventContext());
        InternalEvent event = builder.message(inputEvent.getMessage()).error(inputEvent.getError().orElse(null)).variables(inputEvent.getVariables()).parameters(inputEvent.getParameters()).properties(inputEvent.getProperties()).build();
        return this.executeEvent(event);
    }

    public final CompletableFuture<Event> execute(Event event) {
        InternalEvent internalEvent = event instanceof InternalEvent ? InternalEvent.builder(this.createEventContext(), (InternalEvent)event).build() : InternalEvent.builder(this.createEventContext()).message(event.getMessage()).error(event.getError().orElse(null)).variables(event.getVariables()).parameters(event.getParameters()).properties(event.getProperties()).build();
        return this.executeEvent(internalEvent);
    }

    private CompletableFuture<Event> executeEvent(InternalEvent event) {
        return Mono.from(MessageProcessors.process(event, this.getExecutableFunction())).onErrorMap(throwable -> {
            MessagingException messagingException = (MessagingException)((Object)((Object)throwable));
            InternalEvent messagingExceptionEvent = messagingException.getEvent();
            return new ComponentExecutionException(((Error)messagingExceptionEvent.getError().get()).getCause(), (Event)messagingExceptionEvent);
        }).cast(Event.class).toFuture();
    }

    protected InternalEventContext createEventContext() {
        return DefaultEventContext.create(this.muleContext.getUniqueIdString(), this.muleContext.getId(), this.getLocation());
    }

    protected ReactiveProcessor getExecutableFunction() {
        if (this instanceof ReactiveProcessor) {
            return (ReactiveProcessor)((Object)this);
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Method getExecutableFunction not redefined and instance %s is not of type ReactiveProcessor", new Object[]{this})));
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

