/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.ObjectUtils;
import org.mule.runtime.core.internal.component.ComponentUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public abstract class AbstractInterceptingMessageProcessorBase
extends AbstractAnnotatedObject
implements Processor,
MuleContextAware {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext muleContext;
    protected Processor next;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.next instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.next)).setMuleContext(context);
        }
    }

    public FlowConstruct getFlowConstruct() {
        return ComponentUtils.getFromAnnotatedObjectOrFail(this.muleContext.getConfigurationComponentLocator(), (AnnotatedObject)this);
    }

    public final Processor getListener() {
        return this.next;
    }

    public void setListener(Processor next) {
        this.next = next;
    }

    protected InternalEvent processNext(InternalEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (event == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.trace("MuleEvent is null.  Next MessageProcessor '" + this.next.getClass().getName() + "' will not be invoked.");
            }
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Invoking next MessageProcessor: '" + this.next.getClass().getName() + "' ");
        }
        return MessageProcessors.processToApply(event, this.next);
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }

    protected boolean isEventValid(InternalEvent event) {
        return event != null;
    }

    protected ReactiveProcessor applyNext() {
        if (this.next == null) {
            return publisher -> publisher;
        }
        return publisher -> Flux.from((Publisher)publisher).doOnNext(event -> this.logNextMessageProcessorInvocation()).transform((Function)this.next);
    }

    private void logNextMessageProcessorInvocation() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Invoking next MessageProcessor: '" + this.next.getClass().getName() + "' ");
        }
    }
}

