/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.DrainUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxBufferPredicate<T, C extends Collection<? super T>>
extends FluxSource<T, C> {
    final Predicate<? super T> predicate;
    final Supplier<C> bufferSupplier;
    final Mode mode;

    FluxBufferPredicate(Flux<? extends T> source, Predicate<? super T> predicate, Supplier<C> bufferSupplier, Mode mode) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
        this.mode = mode;
    }

    @Override
    public long getPrefetch() {
        return 1L;
    }

    @Override
    public void subscribe(Subscriber<? super C> s) {
        Collection initialBuffer;
        try {
            initialBuffer = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null initial buffer");
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        BufferPredicateSubscriber<? super T, Collection> parent = new BufferPredicateSubscriber<T, Collection>(s, initialBuffer, this.bufferSupplier, this.predicate, this.mode);
        this.source.subscribe(parent);
    }

    static final class BufferPredicateSubscriber<T, C extends Collection<? super T>>
    extends AbstractQueue<C>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, C>,
    BooleanSupplier {
        final Subscriber<? super C> actual;
        final Supplier<C> bufferSupplier;
        final Mode mode;
        final Predicate<? super T> predicate;
        C buffer;
        boolean done;
        volatile boolean fastpath;
        volatile long requested;
        static final AtomicLongFieldUpdater<BufferPredicateSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BufferPredicateSubscriber.class, "requested");
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<BufferPredicateSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(BufferPredicateSubscriber.class, Subscription.class, "s");

        BufferPredicateSubscriber(Subscriber<? super C> actual, C initialBuffer, Supplier<C> bufferSupplier, Predicate<? super T> predicate, Mode mode) {
            this.actual = actual;
            this.buffer = initialBuffer;
            this.bufferSupplier = bufferSupplier;
            this.predicate = predicate;
            this.mode = mode;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (n == Long.MAX_VALUE) {
                    this.fastpath = true;
                    this.requested = Long.MAX_VALUE;
                    this.s.request(Long.MAX_VALUE);
                } else if (!DrainUtils.postCompleteRequest(n, this.actual, this, REQUESTED, this, this)) {
                    this.s.request(1L);
                }
            }
        }

        public void cancel() {
            Operators.terminate(S, this);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean requestMore;
            boolean match;
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            C b = this.buffer;
            try {
                match = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            if (this.mode == Mode.UNTIL && match) {
                b.add(t);
                requestMore = this.onNextNewBuffer();
            } else if (this.mode == Mode.UNTIL_CUT_BEFORE && match) {
                requestMore = this.onNextNewBuffer();
                b = this.buffer;
                b.add(t);
            } else if (this.mode == Mode.WHILE && !match) {
                requestMore = this.onNextNewBuffer();
            } else {
                b.add(t);
                return this.fastpath || this.requested == 0L;
            }
            return !requestMore;
        }

        private C triggerNewBuffer() {
            Collection c;
            C b = this.buffer;
            if (b.isEmpty()) {
                return null;
            }
            try {
                c = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e));
                return null;
            }
            this.buffer = c;
            return b;
        }

        private boolean onNextNewBuffer() {
            C b = this.triggerNewBuffer();
            if (b != null) {
                return this.emit(b);
            }
            return true;
        }

        @Override
        public Subscriber<? super C> actual() {
            return this.actual;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.buffer = null;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            DrainUtils.postComplete(this.actual, this, REQUESTED, this, this);
        }

        boolean emit(C b) {
            if (this.fastpath) {
                this.actual.onNext(b);
                return false;
            }
            long r = REQUESTED.getAndDecrement(this);
            if (r > 0L) {
                this.actual.onNext(b);
                return this.requested > 0L;
            }
            this.cancel();
            this.actual.onError((Throwable)Exceptions.failWithOverflow("Could not emit buffer due to lack of requests"));
            return false;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
                case CANCELLED: {
                    return this.getAsBoolean();
                }
                case CAPACITY: {
                    C b = this.buffer;
                    return b != null ? (long)b.size() : 0L;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public boolean getAsBoolean() {
            return this.s == Operators.cancelledSubscription();
        }

        @Override
        public Iterator<C> iterator() {
            if (this.isEmpty()) {
                return Collections.emptyIterator();
            }
            return Collections.singleton(this.buffer).iterator();
        }

        @Override
        public boolean offer(C objects) {
            throw new IllegalArgumentException();
        }

        @Override
        public C poll() {
            C b = this.buffer;
            if (b != null && !b.isEmpty()) {
                this.buffer = null;
                return b;
            }
            return null;
        }

        @Override
        public C peek() {
            return this.buffer;
        }

        @Override
        public int size() {
            return this.buffer == null || this.buffer.isEmpty() ? 0 : 1;
        }

        @Override
        public String toString() {
            return "FluxBufferPredicate";
        }
    }

    public static enum Mode {
        UNTIL,
        UNTIL_CUT_BEFORE,
        WHILE;

    }
}

