/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoDefer<T>
extends Mono<T> {
    final Supplier<? extends Publisher<? extends T>> supplier;

    MonoDefer(Supplier<? extends Publisher<? extends T>> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier");
    }

    public void subscribe(Subscriber<? super T> s) {
        Publisher<? extends T> p;
        try {
            p = Objects.requireNonNull(this.supplier.get(), "The Mono returned by the supplier is null");
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        p.subscribe(s);
    }
}

