/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxFlatMap;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoFlatMap<T, R>
extends Flux<R> {
    final Mono<? extends T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;

    MonoFlatMap(Mono<? extends T> source, Function<? super T, ? extends Publisher<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    public void subscribe(Subscriber<? super R> s) {
        if (FluxFlatMap.trySubscribeScalarMap(this.source, s, this.mapper, false)) {
            return;
        }
        this.source.subscribe(new FlatMapMain<T, R>(s, this.mapper));
    }

    static final class FlatMapInner<R>
    implements InnerConsumer<R> {
        final FlatMapMain<?, R> parent;
        final Subscriber<? super R> actual;

        FlatMapInner(FlatMapMain<?, R> parent, Subscriber<? super R> actual) {
            this.parent = parent;
            this.actual = actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.parent.inner;
                }
                case ACTUAL: {
                    return this.parent;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.parent.requested;
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            this.parent.onSubscribeInner(s);
        }

        public void onNext(R t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }
    }

    static final class FlatMapMain<T, R>
    implements InnerOperator<T, R> {
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        Subscription main;
        volatile Subscription inner;
        static final AtomicReferenceFieldUpdater<FlatMapMain, Subscription> INNER = AtomicReferenceFieldUpdater.newUpdater(FlatMapMain.class, Subscription.class, "inner");
        volatile long requested;
        static final AtomicLongFieldUpdater<FlatMapMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(FlatMapMain.class, "requested");
        boolean hasValue;

        FlatMapMain(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.main;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(Scannable.from(this.inner));
        }

        @Override
        public Subscriber<? super R> actual() {
            return this.actual;
        }

        public void request(long n) {
            Subscription a = this.inner;
            if (a != null) {
                a.request(n);
            } else if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                a = this.inner;
                if (a != null && (n = REQUESTED.getAndSet(this, 0L)) != 0L) {
                    a.request(n);
                }
            }
        }

        public void cancel() {
            this.main.cancel();
            Operators.terminate(INNER, this);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.main, s)) {
                this.main = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        void onSubscribeInner(Subscription s) {
            long r;
            if (Operators.setOnce(INNER, this, s) && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                s.request(r);
            }
        }

        public void onNext(T t) {
            Publisher<? extends R> p;
            this.hasValue = true;
            try {
                p = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Publisher.");
            }
            catch (Throwable ex) {
                this.actual.onError(Operators.onOperatorError(this, ex, t));
                return;
            }
            if (p instanceof Callable) {
                Object v;
                try {
                    v = ((Callable)p).call();
                }
                catch (Throwable ex) {
                    this.actual.onError(Operators.onOperatorError(this, ex, t));
                    return;
                }
                if (v == null) {
                    this.actual.onComplete();
                } else {
                    this.onSubscribeInner(Operators.scalarSubscription(this.actual, v));
                }
                return;
            }
            p.subscribe(new FlatMapInner<R>(this, this.actual));
        }

        public void onError(Throwable t) {
            if (this.hasValue) {
                Operators.onErrorDropped(t);
                return;
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (!this.hasValue) {
                this.actual.onComplete();
            }
        }
    }
}

