/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxUsing;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoUsing<T, S>
extends Mono<T>
implements Fuseable {
    final Callable<S> resourceSupplier;
    final Function<? super S, ? extends Publisher<? extends T>> sourceFactory;
    final Consumer<? super S> resourceCleanup;
    final boolean eager;

    MonoUsing(Callable<S> resourceSupplier, Function<? super S, ? extends Publisher<? extends T>> sourceFactory, Consumer<? super S> resourceCleanup, boolean eager) {
        this.resourceSupplier = Objects.requireNonNull(resourceSupplier, "resourceSupplier");
        this.sourceFactory = Objects.requireNonNull(sourceFactory, "sourceFactory");
        this.resourceCleanup = Objects.requireNonNull(resourceCleanup, "resourceCleanup");
        this.eager = eager;
    }

    public void subscribe(Subscriber<? super T> s) {
        Publisher<? extends T> p;
        S resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        try {
            p = Objects.requireNonNull(this.sourceFactory.apply(resource), "The sourceFactory returned a null value");
        }
        catch (Throwable e) {
            try {
                this.resourceCleanup.accept(resource);
            }
            catch (Throwable ex) {
                ex.addSuppressed(Operators.onOperatorError(e));
                e = ex;
            }
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (p instanceof Fuseable) {
            p.subscribe(new FluxUsing.UsingFuseableSubscriber<T, S>(s, this.resourceCleanup, resource, this.eager));
        } else if (s instanceof Fuseable.ConditionalSubscriber) {
            p.subscribe(new FluxUsing.UsingConditionalSubscriber((Fuseable.ConditionalSubscriber)s, this.resourceCleanup, resource, this.eager));
        } else {
            p.subscribe(new FluxUsing.UsingSubscriber<T, S>(s, this.resourceCleanup, resource, this.eager));
        }
    }
}

